@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.PrivateEndpointConnectionPropertiesArgs
import com.pulumi.azurenative.devices.kotlin.inputs.PrivateEndpointConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection of a provisioning service
 * Azure REST API version: 2022-12-12. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnection_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotDpsResourcePrivateEndpointConnection = new AzureNative.Devices.IotDpsResourcePrivateEndpointConnection("iotDpsResourcePrivateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myPrivateEndpointConnection",
 *         Properties = new AzureNative.Devices.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Devices.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Approved by johndoe@contoso.com",
 *                 Status = AzureNative.Devices.PrivateLinkServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myFirstProvisioningService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotDpsResourcePrivateEndpointConnection(ctx, "iotDpsResourcePrivateEndpointConnection", &devices.IotDpsResourcePrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateEndpointConnection"),
 * 			Properties: &devices.PrivateEndpointConnectionPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &devices.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 					Status:      pulumi.String(devices.PrivateLinkServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myFirstProvisioningService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection;
 * import com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs;
 * import com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotDpsResourcePrivateEndpointConnection = new IotDpsResourcePrivateEndpointConnection("iotDpsResourcePrivateEndpointConnection", IotDpsResourcePrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myPrivateEndpointConnection")
 *             .properties(PrivateEndpointConnectionPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("Approved by johndoe@contoso.com")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myFirstProvisioningService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotDpsResourcePrivateEndpointConnection myPrivateEndpointConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection
 * @property properties The properties of a private endpoint connection
 * @property resourceGroupName The name of the resource group that contains the provisioning service.
 * @property resourceName The name of the provisioning service.
 */
public data class IotDpsResourcePrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs =
        com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotDpsResourcePrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class IotDpsResourcePrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection
     */
    @JvmName("eqgmeedtwdmoiego")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The properties of a private endpoint connection
     */
    @JvmName("rtxccmigvgkjailx")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the provisioning service.
     */
    @JvmName("vguuosgqpvghnpsy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the provisioning service.
     */
    @JvmName("sulunmkqrsdvcftm")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the private endpoint connection
     */
    @JvmName("mptrxrhfomogmxlc")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The properties of a private endpoint connection
     */
    @JvmName("cuxehxlsbjjhorkn")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a private endpoint connection
     */
    @JvmName("afmrcxexaelvgmlw")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the provisioning service.
     */
    @JvmName("wqrnqgpcyycqeedv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the provisioning service.
     */
    @JvmName("fslpxkaijxbtyvyc")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): IotDpsResourcePrivateEndpointConnectionArgs =
        IotDpsResourcePrivateEndpointConnectionArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
}
