@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.ArmIdentityArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
 * @property userAssignedIdentities
 */
public data class ArmIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.ArmIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.ArmIdentityArgs =
        com.pulumi.azurenative.devices.inputs.ArmIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ArmIdentityArgs].
 */
@PulumiTagMarker
public class ArmIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("xwpaosojjfhrduxf")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("lmdqgybrlnwvywle")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("jbldjaokwoixbufs")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rdlhynnudsdudoww")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("gsowtrrgbgewhqaw")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("fpunthbgltvotqsq")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values
     */
    @JvmName("hhefunkgykgsxgat")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ArmIdentityArgs = ArmIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
