@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.EventHubConsumerGroupNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The EventHub consumer group name.
 * @property name EventHub consumer group name
 */
public data class EventHubConsumerGroupNameArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.EventHubConsumerGroupNameArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.EventHubConsumerGroupNameArgs =
        com.pulumi.azurenative.devices.inputs.EventHubConsumerGroupNameArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubConsumerGroupNameArgs].
 */
@PulumiTagMarker
public class EventHubConsumerGroupNameArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value EventHub consumer group name
     */
    @JvmName("jvsoocicnaexdcts")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value EventHub consumer group name
     */
    @JvmName("otrpwbjowxvijjxo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventHubConsumerGroupNameArgs = EventHubConsumerGroupNameArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
