@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IpFilterRuleArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.IpFilterActionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The IP filter rules for the IoT hub.
 * @property action The desired action for requests captured by this rule.
 * @property filterName The name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 */
public data class IpFilterRuleArgs(
    public val action: Output<IpFilterActionType>,
    public val filterName: Output<String>,
    public val ipMask: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IpFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IpFilterRuleArgs =
        com.pulumi.azurenative.devices.inputs.IpFilterRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filterName(filterName.applyValue({ args0 -> args0 }))
            .ipMask(ipMask.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpFilterRuleArgs].
 */
@PulumiTagMarker
public class IpFilterRuleArgsBuilder internal constructor() {
    private var action: Output<IpFilterActionType>? = null

    private var filterName: Output<String>? = null

    private var ipMask: Output<String>? = null

    /**
     * @param value The desired action for requests captured by this rule.
     */
    @JvmName("fuojoksjklttjusn")
    public suspend fun action(`value`: Output<IpFilterActionType>) {
        this.action = value
    }

    /**
     * @param value The name of the IP filter rule.
     */
    @JvmName("anxuvaqlpjdgchil")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("mqvakfeflaiyflii")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value The desired action for requests captured by this rule.
     */
    @JvmName("grnuvhsyfpfndeei")
    public suspend fun action(`value`: IpFilterActionType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The name of the IP filter rule.
     */
    @JvmName("yfwbqjhbcbfturgj")
    public suspend fun filterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("asjkrradhthapqcl")
    public suspend fun ipMask(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    internal fun build(): IpFilterRuleArgs = IpFilterRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        filterName = filterName ?: throw PulumiNullFieldException("filterName"),
        ipMask = ipMask ?: throw PulumiNullFieldException("ipMask"),
    )
}
