@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.KeyVaultKeyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of the KeyVault key.
 * @property identity Managed identity properties of KeyVault Key.
 * @property keyIdentifier The identifier of the key.
 */
public data class KeyVaultKeyPropertiesArgs(
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val keyIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.KeyVaultKeyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.KeyVaultKeyPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.KeyVaultKeyPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultKeyPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyPropertiesArgsBuilder internal constructor() {
    private var identity: Output<ManagedIdentityArgs>? = null

    private var keyIdentifier: Output<String>? = null

    /**
     * @param value Managed identity properties of KeyVault Key.
     */
    @JvmName("lsomjishayopyioy")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The identifier of the key.
     */
    @JvmName("ksevyqhxiximtfgj")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value Managed identity properties of KeyVault Key.
     */
    @JvmName("ecvavrjqrrgfcjdq")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties of KeyVault Key.
     */
    @JvmName("rthoicweqfbvspdf")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The identifier of the key.
     */
    @JvmName("vscitnlgjiorclee")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    internal fun build(): KeyVaultKeyPropertiesArgs = KeyVaultKeyPropertiesArgs(
        identity = identity,
        keyIdentifier = keyIdentifier,
    )
}
