@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysForKeyNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyName Logical key name to get key-values for.
 * @property provisioningServiceName Name of the provisioning service.
 * @property resourceGroupName The name of the resource group that contains the provisioning service.
 */
public data class ListIotDpsResourceKeysForKeyNamePlainArgs(
    public val keyName: String,
    public val provisioningServiceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysForKeyNamePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysForKeyNamePlainArgs =
        com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysForKeyNamePlainArgs.builder()
            .keyName(keyName.let({ args0 -> args0 }))
            .provisioningServiceName(provisioningServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIotDpsResourceKeysForKeyNamePlainArgs].
 */
@PulumiTagMarker
public class ListIotDpsResourceKeysForKeyNamePlainArgsBuilder internal constructor() {
    private var keyName: String? = null

    private var provisioningServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Logical key name to get key-values for.
     */
    @JvmName("ireklehbkfjyfbgl")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value Name of the provisioning service.
     */
    @JvmName("nddfanqwvpmmajow")
    public suspend fun provisioningServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the provisioning service.
     */
    @JvmName("rdcadaixwubexnvt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListIotDpsResourceKeysForKeyNamePlainArgs =
        ListIotDpsResourceKeysForKeyNamePlainArgs(
            keyName = keyName ?: throw PulumiNullFieldException("keyName"),
            provisioningServiceName = provisioningServiceName ?: throw
                PulumiNullFieldException("provisioningServiceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
