@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.MessagingEndpointPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the messaging endpoints used by this IoT hub.
 * @property lockDurationAsIso8601 The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 * @property maxDeliveryCount The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 * @property ttlAsIso8601 The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 */
public data class MessagingEndpointPropertiesArgs(
    public val lockDurationAsIso8601: Output<String>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
    public val ttlAsIso8601: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.MessagingEndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.MessagingEndpointPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.MessagingEndpointPropertiesArgs.builder()
            .lockDurationAsIso8601(lockDurationAsIso8601?.applyValue({ args0 -> args0 }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 }))
            .ttlAsIso8601(ttlAsIso8601?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MessagingEndpointPropertiesArgs].
 */
@PulumiTagMarker
public class MessagingEndpointPropertiesArgsBuilder internal constructor() {
    private var lockDurationAsIso8601: Output<String>? = null

    private var maxDeliveryCount: Output<Int>? = null

    private var ttlAsIso8601: Output<String>? = null

    /**
     * @param value The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("steeleboogpcrymn")
    public suspend fun lockDurationAsIso8601(`value`: Output<String>) {
        this.lockDurationAsIso8601 = value
    }

    /**
     * @param value The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("shpbggwgrgtrhdjw")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("ktonuccpfeymfoly")
    public suspend fun ttlAsIso8601(`value`: Output<String>) {
        this.ttlAsIso8601 = value
    }

    /**
     * @param value The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("svxwbaqntlyrtfwi")
    public suspend fun lockDurationAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockDurationAsIso8601 = mapped
    }

    /**
     * @param value The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("nlinsjcwacfsitlh")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    /**
     * @param value The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
     */
    @JvmName("ymhuhjboywaxdlcr")
    public suspend fun ttlAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttlAsIso8601 = mapped
    }

    internal fun build(): MessagingEndpointPropertiesArgs = MessagingEndpointPropertiesArgs(
        lockDurationAsIso8601 = lockDurationAsIso8601,
        maxDeliveryCount = maxDeliveryCount,
        ttlAsIso8601 = ttlAsIso8601,
    )
}
