@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.NetworkRuleSetIpRuleArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.NetworkRuleIPAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP Rule to be applied as part of Network Rule Set
 * @property action IP Filter Action
 * @property filterName Name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 */
public data class NetworkRuleSetIpRuleArgs(
    public val action: Output<Either<String, NetworkRuleIPAction>>? = null,
    public val filterName: Output<String>,
    public val ipMask: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.NetworkRuleSetIpRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.NetworkRuleSetIpRuleArgs =
        com.pulumi.azurenative.devices.inputs.NetworkRuleSetIpRuleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filterName(filterName.applyValue({ args0 -> args0 }))
            .ipMask(ipMask.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkRuleSetIpRuleArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetIpRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, NetworkRuleIPAction>>? = null

    private var filterName: Output<String>? = null

    private var ipMask: Output<String>? = null

    /**
     * @param value IP Filter Action
     */
    @JvmName("hmdonwkxbpsceium")
    public suspend fun action(`value`: Output<Either<String, NetworkRuleIPAction>>) {
        this.action = value
    }

    /**
     * @param value Name of the IP filter rule.
     */
    @JvmName("lycqwsbbxcjcfmhp")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("tennxwlfeeeckvad")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value IP Filter Action
     */
    @JvmName("tvpifrulscaachmo")
    public suspend fun action(`value`: Either<String, NetworkRuleIPAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Filter Action
     */
    @JvmName("fchatdgjgonvosmu")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleIPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Filter Action
     */
    @JvmName("hmbsbvohrqxtaese")
    public fun action(`value`: NetworkRuleIPAction) {
        val toBeMapped = Either.ofRight<String, NetworkRuleIPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Name of the IP filter rule.
     */
    @JvmName("jqgnbyfjyvybrowl")
    public suspend fun filterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("ieknpiyjronycmrk")
    public suspend fun ipMask(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    internal fun build(): NetworkRuleSetIpRuleArgs = NetworkRuleSetIpRuleArgs(
        action = action,
        filterName = filterName ?: throw PulumiNullFieldException("filterName"),
        ipMask = ipMask ?: throw PulumiNullFieldException("ipMask"),
    )
}
