@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection of an IotHub
 * @property properties The properties of a private endpoint connection
 */
public data class PrivateEndpointConnectionArgs(
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    /**
     * @param value The properties of a private endpoint connection
     */
    @JvmName("dccekyyyatohfdms")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The properties of a private endpoint connection
     */
    @JvmName("slgyocvvwxxhtund")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a private endpoint connection
     */
    @JvmName("mqnexgwhlhqsmnxn")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
