@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingStorageContainerPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties related to a storage container endpoint.
 * @property authenticationType Method used to authenticate against the storage endpoint
 * @property batchFrequencyInSeconds Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
 * @property connectionString The connection string of the storage account.
 * @property containerName The name of storage container in the storage account.
 * @property encoding Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
 * @property endpointUri The url of the storage endpoint. It must include the protocol https://
 * @property fileNameFormat File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
 * @property id Id of the storage container endpoint
 * @property identity Managed identity properties of routing storage endpoint.
 * @property maxChunkSizeInBytes Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
 * @property resourceGroup The name of the resource group of the storage account.
 * @property subscriptionId The subscription identifier of the storage account.
 */
public data class RoutingStorageContainerPropertiesArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val batchFrequencyInSeconds: Output<Int>? = null,
    public val connectionString: Output<String>? = null,
    public val containerName: Output<String>,
    public val encoding: Output<String>? = null,
    public val endpointUri: Output<String>? = null,
    public val fileNameFormat: Output<String>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val maxChunkSizeInBytes: Output<Int>? = null,
    public val name: Output<String>,
    public val resourceGroup: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingStorageContainerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingStorageContainerPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RoutingStorageContainerPropertiesArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .batchFrequencyInSeconds(batchFrequencyInSeconds?.applyValue({ args0 -> args0 }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .endpointUri(endpointUri?.applyValue({ args0 -> args0 }))
            .fileNameFormat(fileNameFormat?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxChunkSizeInBytes(maxChunkSizeInBytes?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingStorageContainerPropertiesArgs].
 */
@PulumiTagMarker
public class RoutingStorageContainerPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var batchFrequencyInSeconds: Output<Int>? = null

    private var connectionString: Output<String>? = null

    private var containerName: Output<String>? = null

    private var encoding: Output<String>? = null

    private var endpointUri: Output<String>? = null

    private var fileNameFormat: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var maxChunkSizeInBytes: Output<Int>? = null

    private var name: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Method used to authenticate against the storage endpoint
     */
    @JvmName("vnpscuhxxfbkgjav")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
     */
    @JvmName("nmondtrgssonlhfa")
    public suspend fun batchFrequencyInSeconds(`value`: Output<Int>) {
        this.batchFrequencyInSeconds = value
    }

    /**
     * @param value The connection string of the storage account.
     */
    @JvmName("qtepjhrpkpvvixiy")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value The name of storage container in the storage account.
     */
    @JvmName("omceckdlvscchplo")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
     */
    @JvmName("sqitcismlnlpheju")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value The url of the storage endpoint. It must include the protocol https://
     */
    @JvmName("jfjsdtikoqubmptb")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
     */
    @JvmName("uhunumlohfjiqeqy")
    public suspend fun fileNameFormat(`value`: Output<String>) {
        this.fileNameFormat = value
    }

    /**
     * @param value Id of the storage container endpoint
     */
    @JvmName("gbeviesagnlqdisb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Managed identity properties of routing storage endpoint.
     */
    @JvmName("jyivlqbepvchosep")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
     */
    @JvmName("cjkukpiuwsimneyr")
    public suspend fun maxChunkSizeInBytes(`value`: Output<Int>) {
        this.maxChunkSizeInBytes = value
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("ihtrlitifedvchth")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group of the storage account.
     */
    @JvmName("jrfldcagxmrlbyvn")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The subscription identifier of the storage account.
     */
    @JvmName("nrupkhyqvtaufdqr")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Method used to authenticate against the storage endpoint
     */
    @JvmName("bojilgdhxdrwekmo")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the storage endpoint
     */
    @JvmName("hfnqdsesxyhrdtxt")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the storage endpoint
     */
    @JvmName("eawdgyrlhthuwgrx")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
     */
    @JvmName("gbaobhrxrgtnsjby")
    public suspend fun batchFrequencyInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchFrequencyInSeconds = mapped
    }

    /**
     * @param value The connection string of the storage account.
     */
    @JvmName("ukpqmnbispmcodrh")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The name of storage container in the storage account.
     */
    @JvmName("sfeqehhlciaefxrf")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
     */
    @JvmName("hayluesmgrpbiwqj")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The url of the storage endpoint. It must include the protocol https://
     */
    @JvmName("htlvnknpuqdwkeos")
    public suspend fun endpointUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
     */
    @JvmName("ojfsntuloiocmqym")
    public suspend fun fileNameFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNameFormat = mapped
    }

    /**
     * @param value Id of the storage container endpoint
     */
    @JvmName("utrhqrfyfprnvtuf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Managed identity properties of routing storage endpoint.
     */
    @JvmName("etqiwpbksihcuawy")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties of routing storage endpoint.
     */
    @JvmName("nsbysoyvqldnpkli")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
     */
    @JvmName("ohsvtgfoanghraoi")
    public suspend fun maxChunkSizeInBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxChunkSizeInBytes = mapped
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("jjainxhnhyjseuje")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group of the storage account.
     */
    @JvmName("iheoulxadtxtlaea")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The subscription identifier of the storage account.
     */
    @JvmName("uhfgqrttwwroiumx")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): RoutingStorageContainerPropertiesArgs =
        RoutingStorageContainerPropertiesArgs(
            authenticationType = authenticationType,
            batchFrequencyInSeconds = batchFrequencyInSeconds,
            connectionString = connectionString,
            containerName = containerName ?: throw PulumiNullFieldException("containerName"),
            encoding = encoding,
            endpointUri = endpointUri,
            fileNameFormat = fileNameFormat,
            id = id,
            identity = identity,
            maxChunkSizeInBytes = maxChunkSizeInBytes,
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroup = resourceGroup,
            subscriptionId = subscriptionId,
        )
}
