@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AccessRights
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of an IoT hub shared access policy.
 * @property keyName The name of the shared access policy.
 * @property primaryKey The primary key.
 * @property rights The permissions assigned to the shared access policy.
 * @property secondaryKey The secondary key.
 */
public data class SharedAccessSignatureAuthorizationRuleArgs(
    public val keyName: Output<String>,
    public val primaryKey: Output<String>? = null,
    public val rights: Output<AccessRights>,
    public val secondaryKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleArgs =
        com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .rights(rights.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedAccessSignatureAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class SharedAccessSignatureAuthorizationRuleArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var primaryKey: Output<String>? = null

    private var rights: Output<AccessRights>? = null

    private var secondaryKey: Output<String>? = null

    /**
     * @param value The name of the shared access policy.
     */
    @JvmName("xxumahwyfhxnsmkk")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The primary key.
     */
    @JvmName("tlifcejvttkjrjdo")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value The permissions assigned to the shared access policy.
     */
    @JvmName("gwemlvyejuofidsp")
    public suspend fun rights(`value`: Output<AccessRights>) {
        this.rights = value
    }

    /**
     * @param value The secondary key.
     */
    @JvmName("oawbqpbdtjbskvhl")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value The name of the shared access policy.
     */
    @JvmName("bqhbfoksocoppvle")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The primary key.
     */
    @JvmName("vhhtwqthgktugsdu")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value The permissions assigned to the shared access policy.
     */
    @JvmName("lyyqmuubfhqglimq")
    public suspend fun rights(`value`: AccessRights) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value The secondary key.
     */
    @JvmName("sykqesnjrpcqldmm")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    internal fun build(): SharedAccessSignatureAuthorizationRuleArgs =
        SharedAccessSignatureAuthorizationRuleArgs(
            keyName = keyName ?: throw PulumiNullFieldException("keyName"),
            primaryKey = primaryKey,
            rights = rights ?: throw PulumiNullFieldException("rights"),
            secondaryKey = secondaryKey,
        )
}
