@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The IoT hub cloud-to-device messaging properties.
 * @property defaultTtlAsIso8601 The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 * @property feedback The properties of the feedback queue for cloud-to-device messages.
 * @property maxDeliveryCount The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 */
public data class CloudToDevicePropertiesResponse(
    public val defaultTtlAsIso8601: String? = null,
    public val feedback: FeedbackPropertiesResponse? = null,
    public val maxDeliveryCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.CloudToDevicePropertiesResponse):
            CloudToDevicePropertiesResponse = CloudToDevicePropertiesResponse(
            defaultTtlAsIso8601 = javaType.defaultTtlAsIso8601().map({ args0 -> args0 }).orElse(null),
            feedback = javaType.feedback().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.FeedbackPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxDeliveryCount = javaType.maxDeliveryCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
