@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The description of the provisioning service.
 * @property etag The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
 * @property id The resource identifier.
 * @property location The resource location.
 * @property name The resource name.
 * @property properties Service specific properties for a provisioning service
 * @property resourcegroup The resource group of the resource.
 * @property sku Sku info for a provisioning Service.
 * @property subscriptionid The subscription id of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The resource tags.
 * @property type The resource type.
 */
public data class GetIotDpsResourceResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: IotDpsPropertiesDescriptionResponse,
    public val resourcegroup: String? = null,
    public val sku: IotDpsSkuInfoResponse,
    public val subscriptionid: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.GetIotDpsResourceResult):
            GetIotDpsResourceResult = GetIotDpsResourceResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.IotDpsPropertiesDescriptionResponse.Companion.toKotlin(args0)
            }),
            resourcegroup = javaType.resourcegroup().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.IotDpsSkuInfoResponse.Companion.toKotlin(args0)
            }),
            subscriptionid = javaType.subscriptionid().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
