@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The properties of an IoT hub.
 * @property allowedFqdnList List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
 * @property authorizationPolicies The shared access policies you can use to secure a connection to the IoT hub.
 * @property cloudToDevice The IoT hub cloud-to-device messaging properties.
 * @property comments IoT hub comments.
 * @property deviceStreams The device streams properties of iothub.
 * @property disableDeviceSAS If true, all device(including Edge devices but excluding modules) scoped SAS keys cannot be used for authentication.
 * @property disableLocalAuth If true, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication.
 * @property disableModuleSAS If true, all module scoped SAS keys cannot be used for authentication.
 * @property enableDataResidency This property when set to true, will enable data residency, thus, disabling disaster recovery.
 * @property enableFileUploadNotifications If True, file upload notifications are enabled.
 * @property encryption The encryption properties for the IoT hub.
 * @property eventHubEndpoints The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
 * @property features The capabilities and features enabled for the IoT hub.
 * @property hostName The name of the host.
 * @property ipFilterRules The IP filter rules.
 * @property locations Primary and secondary location for iot hub
 * @property messagingEndpoints The messaging endpoint properties for the file upload notification queue.
 * @property minTlsVersion Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
 * @property networkRuleSets Network Rule Set Properties of IotHub
 * @property privateEndpointConnections Private endpoint connections created on this IotHub
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property restrictOutboundNetworkAccess If true, egress from IotHub will be restricted to only the allowed FQDNs that are configured via allowedFqdnList.
 * @property rootCertificate This property store root certificate related information
 * @property routing The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
 * @property state The hub state.
 * @property storageEndpoints The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
 */
public data class IotHubPropertiesResponse(
    public val allowedFqdnList: List<String>? = null,
    public val authorizationPolicies: List<SharedAccessSignatureAuthorizationRuleResponse>? = null,
    public val cloudToDevice: CloudToDevicePropertiesResponse? = null,
    public val comments: String? = null,
    public val deviceStreams: IotHubPropertiesResponseDeviceStreams? = null,
    public val disableDeviceSAS: Boolean? = null,
    public val disableLocalAuth: Boolean? = null,
    public val disableModuleSAS: Boolean? = null,
    public val enableDataResidency: Boolean? = null,
    public val enableFileUploadNotifications: Boolean? = null,
    public val encryption: EncryptionPropertiesDescriptionResponse? = null,
    public val eventHubEndpoints: Map<String, EventHubPropertiesResponse>? = null,
    public val features: String? = null,
    public val hostName: String,
    public val ipFilterRules: List<IpFilterRuleResponse>? = null,
    public val locations: List<IotHubLocationDescriptionResponse>,
    public val messagingEndpoints: Map<String, MessagingEndpointPropertiesResponse>? = null,
    public val minTlsVersion: String? = null,
    public val networkRuleSets: NetworkRuleSetPropertiesResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val restrictOutboundNetworkAccess: Boolean? = null,
    public val rootCertificate: RootCertificatePropertiesResponse? = null,
    public val routing: RoutingPropertiesResponse? = null,
    public val state: String,
    public val storageEndpoints: Map<String, StorageEndpointPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotHubPropertiesResponse):
            IotHubPropertiesResponse = IotHubPropertiesResponse(
            allowedFqdnList = javaType.allowedFqdnList().map({ args0 -> args0 }),
            authorizationPolicies = javaType.authorizationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.SharedAccessSignatureAuthorizationRuleResponse.Companion.toKotlin(args0)
                })
            }),
            cloudToDevice = javaType.cloudToDevice().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.CloudToDevicePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            comments = javaType.comments().map({ args0 -> args0 }).orElse(null),
            deviceStreams = javaType.deviceStreams().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.IotHubPropertiesResponseDeviceStreams.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableDeviceSAS = javaType.disableDeviceSAS().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            disableModuleSAS = javaType.disableModuleSAS().map({ args0 -> args0 }).orElse(null),
            enableDataResidency = javaType.enableDataResidency().map({ args0 -> args0 }).orElse(null),
            enableFileUploadNotifications = javaType.enableFileUploadNotifications().map({ args0 ->
                args0
            }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.EncryptionPropertiesDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventHubEndpoints = javaType.eventHubEndpoints().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.devices.kotlin.outputs.EventHubPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            features = javaType.features().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName(),
            ipFilterRules = javaType.ipFilterRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.IpFilterRuleResponse.Companion.toKotlin(args0)
                })
            }),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.IotHubLocationDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
            messagingEndpoints = javaType.messagingEndpoints().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.devices.kotlin.outputs.MessagingEndpointPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            minTlsVersion = javaType.minTlsVersion().map({ args0 -> args0 }).orElse(null),
            networkRuleSets = javaType.networkRuleSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.NetworkRuleSetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            restrictOutboundNetworkAccess = javaType.restrictOutboundNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            rootCertificate = javaType.rootCertificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RootCertificatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routing = javaType.routing().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            storageEndpoints = javaType.storageEndpoints().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.devices.kotlin.outputs.StorageEndpointPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
