@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
 * @property cosmosDBSqlCollections The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
 * @property eventHubs The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
 * @property serviceBusQueues The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
 * @property serviceBusTopics The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
 * @property storageContainers The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
 */
public data class RoutingEndpointsResponse(
    public val cosmosDBSqlCollections: List<RoutingCosmosDBSqlApiPropertiesResponse>? = null,
    public val eventHubs: List<RoutingEventHubPropertiesResponse>? = null,
    public val serviceBusQueues: List<RoutingServiceBusQueueEndpointPropertiesResponse>? = null,
    public val serviceBusTopics: List<RoutingServiceBusTopicEndpointPropertiesResponse>? = null,
    public val storageContainers: List<RoutingStorageContainerPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutingEndpointsResponse):
            RoutingEndpointsResponse = RoutingEndpointsResponse(
            cosmosDBSqlCollections = javaType.cosmosDBSqlCollections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingCosmosDBSqlApiPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            eventHubs = javaType.eventHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingEventHubPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            serviceBusQueues = javaType.serviceBusQueues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingServiceBusQueueEndpointPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            serviceBusTopics = javaType.serviceBusTopics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingServiceBusTopicEndpointPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            storageContainers = javaType.storageContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingStorageContainerPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
