@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties related to service bus queue endpoint types.
 * @property authenticationType Method used to authenticate against the service bus queue endpoint
 * @property connectionString The connection string of the service bus queue endpoint.
 * @property endpointUri The url of the service bus queue endpoint. It must include the protocol sb://
 * @property entityPath Queue name on the service bus namespace
 * @property id Id of the service bus queue endpoint
 * @property identity Managed identity properties of routing service bus queue endpoint.
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
 * @property resourceGroup The name of the resource group of the service bus queue endpoint.
 * @property subscriptionId The subscription identifier of the service bus queue endpoint.
 */
public data class RoutingServiceBusQueueEndpointPropertiesResponse(
    public val authenticationType: String? = null,
    public val connectionString: String? = null,
    public val endpointUri: String? = null,
    public val entityPath: String? = null,
    public val id: String? = null,
    public val identity: ManagedIdentityResponse? = null,
    public val name: String,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutingServiceBusQueueEndpointPropertiesResponse):
            RoutingServiceBusQueueEndpointPropertiesResponse =
            RoutingServiceBusQueueEndpointPropertiesResponse(
                authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
                connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
                endpointUri = javaType.endpointUri().map({ args0 -> args0 }).orElse(null),
                entityPath = javaType.entityPath().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devices.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name(),
                resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
                subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
