@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.DiagnosticStoragePropertiesArgs.builder
import com.pulumi.azurenative.deviceupdate.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Customer-initiated diagnostic log collection storage properties
 * @property authenticationType Authentication Type
 * @property connectionString ConnectionString of the diagnostic storage account
 * @property resourceId ResourceId of the diagnostic storage account
 */
public data class DiagnosticStoragePropertiesArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>,
    public val connectionString: Output<String>? = null,
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.DiagnosticStoragePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.DiagnosticStoragePropertiesArgs =
        com.pulumi.azurenative.deviceupdate.inputs.DiagnosticStoragePropertiesArgs.builder()
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiagnosticStoragePropertiesArgs].
 */
@PulumiTagMarker
public class DiagnosticStoragePropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var connectionString: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Authentication Type
     */
    @JvmName("qjnfowmqqrjywimp")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value ConnectionString of the diagnostic storage account
     */
    @JvmName("andafbfxqrqdwhpt")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value ResourceId of the diagnostic storage account
     */
    @JvmName("dcwswvawdvqoogro")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Authentication Type
     */
    @JvmName("fonuvxowdvhoagmj")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Authentication Type
     */
    @JvmName("juvymkxfoxxaludg")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Authentication Type
     */
    @JvmName("rnfbpptljoisvfag")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value ConnectionString of the diagnostic storage account
     */
    @JvmName("nnxblcshxqwtuwed")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value ResourceId of the diagnostic storage account
     */
    @JvmName("heqtexfpxyehdidy")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): DiagnosticStoragePropertiesArgs = DiagnosticStoragePropertiesArgs(
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        connectionString = connectionString,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
