@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CMK encryption settings on the Device Update account.
 * @property keyVaultKeyUri The URI of the key vault
 * @property userAssignedIdentity The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account
 */
public data class EncryptionResponse(
    public val keyVaultKeyUri: String? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.EncryptionResponse):
            EncryptionResponse = EncryptionResponse(
            keyVaultKeyUri = javaType.keyVaultKeyUri().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
