@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Group connectivity details.
 * @property customerVisibleFqdns List of customer visible FQDNs.
 * @property groupId Group ID.
 * @property internalFqdn Internal FQDN.
 * @property memberName Member name.
 * @property privateLinkServiceArmRegion PrivateLinkService ARM region.
 * @property redirectMapId Redirect map ID.
 */
public data class GroupConnectivityInformationResponse(
    public val customerVisibleFqdns: List<String>? = null,
    public val groupId: String,
    public val internalFqdn: String,
    public val memberName: String,
    public val privateLinkServiceArmRegion: String? = null,
    public val redirectMapId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.GroupConnectivityInformationResponse):
            GroupConnectivityInformationResponse = GroupConnectivityInformationResponse(
            customerVisibleFqdns = javaType.customerVisibleFqdns().map({ args0 -> args0 }),
            groupId = javaType.groupId(),
            internalFqdn = javaType.internalFqdn(),
            memberName = javaType.memberName(),
            privateLinkServiceArmRegion = javaType.privateLinkServiceArmRegion().map({ args0 ->
                args0
            }).orElse(null),
            redirectMapId = javaType.redirectMapId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
