@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin

import com.pulumi.azurenative.devopsinfrastructure.PoolArgs.builder
import com.pulumi.azurenative.devopsinfrastructure.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.AzureDevOpsOrganizationProfileArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.AzureDevOpsOrganizationProfileArgsBuilder
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.StatefulArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.StatelessAgentProfileArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.VmssFabricProfileArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.VmssFabricProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Concrete tracked resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-10-30-preview.
 * Other available API versions: 2023-12-13-preview, 2024-03-26-preview.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.DevOpsInfrastructure.Pool("pool", new()
 *     {
 *         AgentProfile = new AzureNative.DevOpsInfrastructure.Inputs.StatelessAgentProfileArgs
 *         {
 *             Kind = "Stateless",
 *         },
 *         DevCenterProjectResourceId = "/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES",
 *         FabricProfile = new AzureNative.DevOpsInfrastructure.Inputs.VmssFabricProfileArgs
 *         {
 *             Images = new[]
 *             {
 *                 new AzureNative.DevOpsInfrastructure.Inputs.PoolImageArgs
 *                 {
 *                     ResourceId = "/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest",
 *                 },
 *             },
 *             Kind = "Vmss",
 *             Sku = new AzureNative.DevOpsInfrastructure.Inputs.DevOpsAzureSkuArgs
 *             {
 *                 Name = "Standard_D4ads_v5",
 *             },
 *         },
 *         Location = "eastus",
 *         MaximumConcurrency = 10,
 *         OrganizationProfile = new AzureNative.DevOpsInfrastructure.Inputs.AzureDevOpsOrganizationProfileArgs
 *         {
 *             Kind = "AzureDevOps",
 *             Organizations = new[]
 *             {
 *                 new AzureNative.DevOpsInfrastructure.Inputs.OrganizationArgs
 *                 {
 *                     Url = "https://mseng.visualstudio.com",
 *                 },
 *             },
 *         },
 *         PoolName = "pool",
 *         ProvisioningState = AzureNative.DevOpsInfrastructure.ProvisioningState.Succeeded,
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devopsinfrastructure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsinfrastructure.NewPool(ctx, "pool", &devopsinfrastructure.PoolArgs{
 * 			AgentProfile: devopsinfrastructure.StatelessAgentProfile{
 * 				Kind: "Stateless",
 * 			},
 * 			DevCenterProjectResourceId: pulumi.String("/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES"),
 * 			FabricProfile: &devopsinfrastructure.VmssFabricProfileArgs{
 * 				Images: devopsinfrastructure.PoolImageArray{
 * 					&devopsinfrastructure.PoolImageArgs{
 * 						ResourceId: pulumi.String("/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest"),
 * 					},
 * 				},
 * 				Kind: pulumi.String("Vmss"),
 * 				Sku: &devopsinfrastructure.DevOpsAzureSkuArgs{
 * 					Name: pulumi.String("Standard_D4ads_v5"),
 * 				},
 * 			},
 * 			Location:           pulumi.String("eastus"),
 * 			MaximumConcurrency: pulumi.Int(10),
 * 			OrganizationProfile: &devopsinfrastructure.AzureDevOpsOrganizationProfileArgs{
 * 				Kind: pulumi.String("AzureDevOps"),
 * 				Organizations: devopsinfrastructure.OrganizationArray{
 * 					&devopsinfrastructure.OrganizationArgs{
 * 						Url: pulumi.String("https://mseng.visualstudio.com"),
 * 					},
 * 				},
 * 			},
 * 			PoolName:          pulumi.String("pool"),
 * 			ProvisioningState: pulumi.String(devopsinfrastructure.ProvisioningStateSucceeded),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devopsinfrastructure.Pool;
 * import com.pulumi.azurenative.devopsinfrastructure.PoolArgs;
 * import com.pulumi.azurenative.devopsinfrastructure.inputs.VmssFabricProfileArgs;
 * import com.pulumi.azurenative.devopsinfrastructure.inputs.DevOpsAzureSkuArgs;
 * import com.pulumi.azurenative.devopsinfrastructure.inputs.AzureDevOpsOrganizationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .agentProfile(StatelessAgentProfileArgs.builder()
 *                 .kind("Stateless")
 *                 .build())
 *             .devCenterProjectResourceId("/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES")
 *             .fabricProfile(VmssFabricProfileArgs.builder()
 *                 .images(PoolImageArgs.builder()
 *                     .resourceId("/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest")
 *                     .build())
 *                 .kind("Vmss")
 *                 .sku(DevOpsAzureSkuArgs.builder()
 *                     .name("Standard_D4ads_v5")
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .maximumConcurrency(10)
 *             .organizationProfile(AzureDevOpsOrganizationProfileArgs.builder()
 *                 .kind("AzureDevOps")
 *                 .organizations(OrganizationArgs.builder()
 *                     .url("https://mseng.visualstudio.com")
 *                     .build())
 *                 .build())
 *             .poolName("pool")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devopsinfrastructure:Pool myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevOpsInfrastructure/pools/{poolName}
 * ```
 * @property agentProfile Defines how the machine will be handled once it executed a job.
 * @property devCenterProjectResourceId The resource id of the DevCenter Project the pool belongs to.
 * @property fabricProfile Defines the type of fabric the agent will run on.
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property maximumConcurrency Defines how many resources can there be created at any given time.
 * @property organizationProfile Defines the organization in which the pool will be used.
 * @property poolName Name of the pool. It needs to be globally unique.
 * @property provisioningState The status of the current operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class PoolArgs(
    public val agentProfile: Output<Either<StatefulArgs, StatelessAgentProfileArgs>>? = null,
    public val devCenterProjectResourceId: Output<String>? = null,
    public val fabricProfile: Output<VmssFabricProfileArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val maximumConcurrency: Output<Int>? = null,
    public val organizationProfile: Output<AzureDevOpsOrganizationProfileArgs>? = null,
    public val poolName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.PoolArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.PoolArgs =
        com.pulumi.azurenative.devopsinfrastructure.PoolArgs.builder()
            .agentProfile(
                agentProfile?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .devCenterProjectResourceId(devCenterProjectResourceId?.applyValue({ args0 -> args0 }))
            .fabricProfile(fabricProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maximumConcurrency(maximumConcurrency?.applyValue({ args0 -> args0 }))
            .organizationProfile(
                organizationProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PoolArgs].
 */
@PulumiTagMarker
public class PoolArgsBuilder internal constructor() {
    private var agentProfile: Output<Either<StatefulArgs, StatelessAgentProfileArgs>>? = null

    private var devCenterProjectResourceId: Output<String>? = null

    private var fabricProfile: Output<VmssFabricProfileArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var maximumConcurrency: Output<Int>? = null

    private var organizationProfile: Output<AzureDevOpsOrganizationProfileArgs>? = null

    private var poolName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines how the machine will be handled once it executed a job.
     */
    @JvmName("ikhaqnvdnpppfjjk")
    public suspend
    fun agentProfile(`value`: Output<Either<StatefulArgs, StatelessAgentProfileArgs>>) {
        this.agentProfile = value
    }

    /**
     * @param value The resource id of the DevCenter Project the pool belongs to.
     */
    @JvmName("onebeewgoatraktm")
    public suspend fun devCenterProjectResourceId(`value`: Output<String>) {
        this.devCenterProjectResourceId = value
    }

    /**
     * @param value Defines the type of fabric the agent will run on.
     */
    @JvmName("pxfskehbtfrselis")
    public suspend fun fabricProfile(`value`: Output<VmssFabricProfileArgs>) {
        this.fabricProfile = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("cmeyvcyfpplcgckt")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mohhximpchvkqawi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Defines how many resources can there be created at any given time.
     */
    @JvmName("wrmpmafgngealwgp")
    public suspend fun maximumConcurrency(`value`: Output<Int>) {
        this.maximumConcurrency = value
    }

    /**
     * @param value Defines the organization in which the pool will be used.
     */
    @JvmName("bopbkstxauaptyoa")
    public suspend fun organizationProfile(`value`: Output<AzureDevOpsOrganizationProfileArgs>) {
        this.organizationProfile = value
    }

    /**
     * @param value Name of the pool. It needs to be globally unique.
     */
    @JvmName("asuxrnihbeodrwwu")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The status of the current operation.
     */
    @JvmName("gqnulcriyrgkugfs")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fvanffacnxnpbsed")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("edkmttsavtfntcmp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines how the machine will be handled once it executed a job.
     */
    @JvmName("cmaemifydwhgrmnf")
    public suspend fun agentProfile(`value`: Either<StatefulArgs, StatelessAgentProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProfile = mapped
    }

    /**
     * @param value Defines how the machine will be handled once it executed a job.
     */
    @JvmName("qwqejgoskcvcqcvp")
    public fun agentProfile(`value`: StatefulArgs) {
        val toBeMapped = Either.ofLeft<StatefulArgs, StatelessAgentProfileArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentProfile = mapped
    }

    /**
     * @param value Defines how the machine will be handled once it executed a job.
     */
    @JvmName("hwpcicoxfpidkyfr")
    public fun agentProfile(`value`: StatelessAgentProfileArgs) {
        val toBeMapped = Either.ofRight<StatefulArgs, StatelessAgentProfileArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentProfile = mapped
    }

    /**
     * @param value The resource id of the DevCenter Project the pool belongs to.
     */
    @JvmName("cegglpcxxohevvsd")
    public suspend fun devCenterProjectResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterProjectResourceId = mapped
    }

    /**
     * @param value Defines the type of fabric the agent will run on.
     */
    @JvmName("pluqljtprhldrwsa")
    public suspend fun fabricProfile(`value`: VmssFabricProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricProfile = mapped
    }

    /**
     * @param argument Defines the type of fabric the agent will run on.
     */
    @JvmName("tljqinidcvlsjpdd")
    public suspend fun fabricProfile(argument: suspend VmssFabricProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VmssFabricProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fabricProfile = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("eovqjcjsyvvydgxe")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("lpkmnjfoxavkubon")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nqdpvlduqcwrxoeu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Defines how many resources can there be created at any given time.
     */
    @JvmName("rmcafirywgvcgwst")
    public suspend fun maximumConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumConcurrency = mapped
    }

    /**
     * @param value Defines the organization in which the pool will be used.
     */
    @JvmName("fwuwpdqqgqmehhmu")
    public suspend fun organizationProfile(`value`: AzureDevOpsOrganizationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationProfile = mapped
    }

    /**
     * @param argument Defines the organization in which the pool will be used.
     */
    @JvmName("diabicuenqgwbclt")
    public suspend
    fun organizationProfile(argument: suspend AzureDevOpsOrganizationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDevOpsOrganizationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.organizationProfile = mapped
    }

    /**
     * @param value Name of the pool. It needs to be globally unique.
     */
    @JvmName("ixxjijotxejjotdb")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The status of the current operation.
     */
    @JvmName("atumluicxmbmckpc")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the current operation.
     */
    @JvmName("rulbbokwdtujktju")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the current operation.
     */
    @JvmName("qlmxonjpqfuxcdco")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xaefrfbpnktksaqp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pwxcbchdrhwvvghp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("beoscujyppohtjjw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PoolArgs = PoolArgs(
        agentProfile = agentProfile,
        devCenterProjectResourceId = devCenterProjectResourceId,
        fabricProfile = fabricProfile,
        identity = identity,
        location = location,
        maximumConcurrency = maximumConcurrency,
        organizationProfile = organizationProfile,
        poolName = poolName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
