@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.ArtifactSourceArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.azurenative.devtestlab.kotlin.enums.SourceControlType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties of an artifact source.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### ArtifactSources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DevTestLab.ArtifactSource("artifactSource", new()
 *     {
 *         ArmTemplateFolderPath = "{armTemplateFolderPath}",
 *         BranchRef = "{branchRef}",
 *         DisplayName = "{displayName}",
 *         FolderPath = "{folderPath}",
 *         LabName = "{labName}",
 *         Name = "{artifactSourceName}",
 *         ResourceGroupName = "resourceGroupName",
 *         SecurityToken = "{securityToken}",
 *         SourceType = "{VsoGit|GitHub|StorageAccount}",
 *         Status = "{Enabled|Disabled}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Uri = "{artifactSourceUri}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewArtifactSource(ctx, "artifactSource", &devtestlab.ArtifactSourceArgs{
 * 			ArmTemplateFolderPath: pulumi.String("{armTemplateFolderPath}"),
 * 			BranchRef:             pulumi.String("{branchRef}"),
 * 			DisplayName:           pulumi.String("{displayName}"),
 * 			FolderPath:            pulumi.String("{folderPath}"),
 * 			LabName:               pulumi.String("{labName}"),
 * 			Name:                  pulumi.String("{artifactSourceName}"),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			SecurityToken:         pulumi.String("{securityToken}"),
 * 			SourceType:            pulumi.String("{VsoGit|GitHub|StorageAccount}"),
 * 			Status:                pulumi.String("{Enabled|Disabled}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Uri: pulumi.String("{artifactSourceUri}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ArtifactSource;
 * import com.pulumi.azurenative.devtestlab.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .armTemplateFolderPath("{armTemplateFolderPath}")
 *             .branchRef("{branchRef}")
 *             .displayName("{displayName}")
 *             .folderPath("{folderPath}")
 *             .labName("{labName}")
 *             .name("{artifactSourceName}")
 *             .resourceGroupName("resourceGroupName")
 *             .securityToken("{securityToken}")
 *             .sourceType("{VsoGit|GitHub|StorageAccount}")
 *             .status("{Enabled|Disabled}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .uri("{artifactSourceUri}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ArtifactSource {artifactSourceName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}
 * ```
 * @property armTemplateFolderPath The folder containing Azure Resource Manager templates.
 * @property branchRef The artifact source's branch reference.
 * @property displayName The artifact source's display name.
 * @property folderPath The folder containing artifacts.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the artifact source.
 * @property resourceGroupName The name of the resource group.
 * @property securityToken The security token to authenticate to the artifact source.
 * @property sourceType The artifact source's type.
 * @property status Indicates if the artifact source is enabled (values: Enabled, Disabled).
 * @property tags The tags of the resource.
 * @property uri The artifact source's URI.
 */
public data class ArtifactSourceArgs(
    public val armTemplateFolderPath: Output<String>? = null,
    public val branchRef: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val folderPath: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityToken: Output<String>? = null,
    public val sourceType: Output<Either<String, SourceControlType>>? = null,
    public val status: Output<Either<String, EnableStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.ArtifactSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.ArtifactSourceArgs =
        com.pulumi.azurenative.devtestlab.ArtifactSourceArgs.builder()
            .armTemplateFolderPath(armTemplateFolderPath?.applyValue({ args0 -> args0 }))
            .branchRef(branchRef?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityToken(securityToken?.applyValue({ args0 -> args0 }))
            .sourceType(
                sourceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArtifactSourceArgs].
 */
@PulumiTagMarker
public class ArtifactSourceArgsBuilder internal constructor() {
    private var armTemplateFolderPath: Output<String>? = null

    private var branchRef: Output<String>? = null

    private var displayName: Output<String>? = null

    private var folderPath: Output<String>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityToken: Output<String>? = null

    private var sourceType: Output<Either<String, SourceControlType>>? = null

    private var status: Output<Either<String, EnableStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The folder containing Azure Resource Manager templates.
     */
    @JvmName("nucamrsxutenvbkh")
    public suspend fun armTemplateFolderPath(`value`: Output<String>) {
        this.armTemplateFolderPath = value
    }

    /**
     * @param value The artifact source's branch reference.
     */
    @JvmName("qiuvyhcmejisryyq")
    public suspend fun branchRef(`value`: Output<String>) {
        this.branchRef = value
    }

    /**
     * @param value The artifact source's display name.
     */
    @JvmName("ovaemikuweurfqsx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The folder containing artifacts.
     */
    @JvmName("xvnmhikwxghipjhu")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("lreptqsdirjgpbtv")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("xyiqnhkuninfvlhp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the artifact source.
     */
    @JvmName("afpspsinbyfrfcha")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("flndiceajxficrkb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security token to authenticate to the artifact source.
     */
    @JvmName("knfnoxosmjuhydgt")
    public suspend fun securityToken(`value`: Output<String>) {
        this.securityToken = value
    }

    /**
     * @param value The artifact source's type.
     */
    @JvmName("knyvklvkfpilosro")
    public suspend fun sourceType(`value`: Output<Either<String, SourceControlType>>) {
        this.sourceType = value
    }

    /**
     * @param value Indicates if the artifact source is enabled (values: Enabled, Disabled).
     */
    @JvmName("dqfemdtupsutdadg")
    public suspend fun status(`value`: Output<Either<String, EnableStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("gcmvnhuicwncjwfv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The artifact source's URI.
     */
    @JvmName("fmcldupwoptcvxhr")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The folder containing Azure Resource Manager templates.
     */
    @JvmName("pwpismpqscjbvlkm")
    public suspend fun armTemplateFolderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armTemplateFolderPath = mapped
    }

    /**
     * @param value The artifact source's branch reference.
     */
    @JvmName("fkptpmapukgoetwu")
    public suspend fun branchRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchRef = mapped
    }

    /**
     * @param value The artifact source's display name.
     */
    @JvmName("mrtmreqnffpqxxpb")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The folder containing artifacts.
     */
    @JvmName("cnvnryvyyclkokca")
    public suspend fun folderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("woypghuuosselsei")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("prhnxjndjklptice")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the artifact source.
     */
    @JvmName("hrsonblvtugfvlyl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ulrrgqmijuntwdpw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security token to authenticate to the artifact source.
     */
    @JvmName("swvjafgayksurnrs")
    public suspend fun securityToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param value The artifact source's type.
     */
    @JvmName("btinnuvabyafroee")
    public suspend fun sourceType(`value`: Either<String, SourceControlType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The artifact source's type.
     */
    @JvmName("xffabuowmspaypmk")
    public fun sourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceControlType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The artifact source's type.
     */
    @JvmName("pdbsqsdtwrvdeusy")
    public fun sourceType(`value`: SourceControlType) {
        val toBeMapped = Either.ofRight<String, SourceControlType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Indicates if the artifact source is enabled (values: Enabled, Disabled).
     */
    @JvmName("kwxlithnokyxwsph")
    public suspend fun status(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the artifact source is enabled (values: Enabled, Disabled).
     */
    @JvmName("jrwdtmhfeqqtcgvr")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the artifact source is enabled (values: Enabled, Disabled).
     */
    @JvmName("fwsdhmtmotiwmsjy")
    public fun status(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("jfscsasrvifirpnf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("sojckggqgeaeeity")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The artifact source's URI.
     */
    @JvmName("jvfemdaayoxxdskh")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ArtifactSourceArgs = ArtifactSourceArgs(
        armTemplateFolderPath = armTemplateFolderPath,
        branchRef = branchRef,
        displayName = displayName,
        folderPath = folderPath,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        securityToken = securityToken,
        sourceType = sourceType,
        status = status,
        tags = tags,
        uri = uri,
    )
}
