@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesCustomResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromPlanResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromVmResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskStorageTypeInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesCustomResponse.Companion.toKotlin as customImagePropertiesCustomResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromPlanResponse.Companion.toKotlin as customImagePropertiesFromPlanResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromVmResponse.Companion.toKotlin as customImagePropertiesFromVmResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskStorageTypeInfoResponse.Companion.toKotlin as dataDiskStorageTypeInfoResponseToKotlin

/**
 * Builder for [CustomImage].
 */
@PulumiTagMarker
public class CustomImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomImageArgs = CustomImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomImageArgsBuilder.() -> Unit) {
        val builder = CustomImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomImage {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.CustomImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomImage(builtJavaResource)
    }
}

/**
 * A custom image.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### CustomImages_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customImage = new AzureNative.DevTestLab.CustomImage("customImage", new()
 *     {
 *         Description = "My Custom Image",
 *         LabName = "{labName}",
 *         Name = "{customImageName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Vm = new AzureNative.DevTestLab.Inputs.CustomImagePropertiesFromVmArgs
 *         {
 *             LinuxOsInfo = new AzureNative.DevTestLab.Inputs.LinuxOsInfoArgs
 *             {
 *                 LinuxOsState = AzureNative.DevTestLab.LinuxOsState.NonDeprovisioned,
 *             },
 *             SourceVmId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewCustomImage(ctx, "customImage", &devtestlab.CustomImageArgs{
 * 			Description:       pulumi.String("My Custom Image"),
 * 			LabName:           pulumi.String("{labName}"),
 * 			Name:              pulumi.String("{customImageName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Vm: &devtestlab.CustomImagePropertiesFromVmArgs{
 * 				LinuxOsInfo: &devtestlab.LinuxOsInfoArgs{
 * 					LinuxOsState: pulumi.String(devtestlab.LinuxOsStateNonDeprovisioned),
 * 				},
 * 				SourceVmId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.CustomImage;
 * import com.pulumi.azurenative.devtestlab.CustomImageArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromVmArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.LinuxOsInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customImage = new CustomImage("customImage", CustomImageArgs.builder()
 *             .description("My Custom Image")
 *             .labName("{labName}")
 *             .name("{customImageName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .vm(CustomImagePropertiesFromVmArgs.builder()
 *                 .linuxOsInfo(LinuxOsInfoArgs.builder()
 *                     .linuxOsState("NonDeprovisioned")
 *                     .build())
 *                 .sourceVmId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:CustomImage {customImageName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}
 * ```
 */
public class CustomImage internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.CustomImage,
) : KotlinCustomResource(javaResource, CustomImageMapper) {
    /**
     * The author of the custom image.
     */
    public val author: Output<String>?
        get() = javaResource.author().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation date of the custom image.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Storage information about the plan related to this custom image
     */
    public val customImagePlan: Output<CustomImagePropertiesFromPlanResponse>?
        get() = javaResource.customImagePlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customImagePropertiesFromPlanResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Storage information about the data disks present in the custom image
     */
    public val dataDiskStorageInfo: Output<List<DataDiskStorageTypeInfoResponse>>?
        get() = javaResource.dataDiskStorageInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dataDiskStorageTypeInfoResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The description of the custom image.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
     */
    public val isPlanAuthorized: Output<Boolean>?
        get() = javaResource.isPlanAuthorized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Managed Image Id backing the custom image.
     */
    public val managedImageId: Output<String>?
        get() = javaResource.managedImageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Managed Snapshot Id backing the custom image.
     */
    public val managedSnapshotId: Output<String>?
        get() = javaResource.managedSnapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * The VHD from which the image is to be created.
     */
    public val vhd: Output<CustomImagePropertiesCustomResponse>?
        get() = javaResource.vhd().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customImagePropertiesCustomResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The virtual machine from which the image is to be created.
     */
    public val vm: Output<CustomImagePropertiesFromVmResponse>?
        get() = javaResource.vm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customImagePropertiesFromVmResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object CustomImageMapper : ResourceMapper<CustomImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.CustomImage::class == javaResource::class

    override fun map(javaResource: Resource): CustomImage = CustomImage(
        javaResource as
            com.pulumi.azurenative.devtestlab.CustomImage,
    )
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomImage].
 */
public suspend fun customImage(name: String, block: suspend CustomImageResourceBuilder.() -> Unit):
    CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customImage(name: String): CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
