@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * A Disk.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Disks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.DevTestLab.Disk("disk", new()
 *     {
 *         DiskSizeGiB = 1023,
 *         DiskType = AzureNative.DevTestLab.StorageType.Standard,
 *         LabName = "{labName}",
 *         LeasedByLabVmId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName",
 *         Name = "{diskName}",
 *         ResourceGroupName = "resourceGroupName",
 *         UserName = "{userId}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewDisk(ctx, "disk", &devtestlab.DiskArgs{
 * 			DiskSizeGiB:       pulumi.Int(1023),
 * 			DiskType:          pulumi.String(devtestlab.StorageTypeStandard),
 * 			LabName:           pulumi.String("{labName}"),
 * 			LeasedByLabVmId:   pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName"),
 * 			Name:              pulumi.String("{diskName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			UserName:          pulumi.String("{userId}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Disk;
 * import com.pulumi.azurenative.devtestlab.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .diskSizeGiB(1023)
 *             .diskType("Standard")
 *             .labName("{labName}")
 *             .leasedByLabVmId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName")
 *             .name("{diskName}")
 *             .resourceGroupName("resourceGroupName")
 *             .userName("{userId}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Disk {diskName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}
 * ```
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    /**
     * The creation date of the disk.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * When backed by a blob, the name of the VHD blob without extension.
     */
    public val diskBlobName: Output<String>?
        get() = javaResource.diskBlobName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the disk in Gibibytes.
     */
    public val diskSizeGiB: Output<Int>?
        get() = javaResource.diskSizeGiB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage type for the disk (i.e. Standard, Premium).
     */
    public val diskType: Output<String>?
        get() = javaResource.diskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When backed by a blob, the URI of underlying blob.
     */
    public val diskUri: Output<String>?
        get() = javaResource.diskUri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
     */
    public val hostCaching: Output<String>?
        get() = javaResource.hostCaching().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the VM to which this disk is leased.
     */
    public val leasedByLabVmId: Output<String>?
        get() = javaResource.leasedByLabVmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When backed by managed disk, this is the ID of the compute disk resource.
     */
    public val managedDiskId: Output<String>?
        get() = javaResource.managedDiskId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * When backed by a blob, the storage account where the blob is.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.azurenative.devtestlab.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
