@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.EnvironmentDeploymentPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.EnvironmentDeploymentPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * An environment, which is essentially an ARM template deployment.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Environments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environment = new AzureNative.DevTestLab.Environment("environment", new()
 *     {
 *         DeploymentProperties = new AzureNative.DevTestLab.Inputs.EnvironmentDeploymentPropertiesArgs
 *         {
 *             ArmTemplateId = "/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}",
 *             Parameters = new() { },
 *         },
 *         LabName = "{labName}",
 *         Name = "{environmentName}",
 *         ResourceGroupName = "resourceGroupName",
 *         UserName = "@me",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewEnvironment(ctx, "environment", &devtestlab.EnvironmentArgs{
 * 			DeploymentProperties: &devtestlab.EnvironmentDeploymentPropertiesArgs{
 * 				ArmTemplateId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}"),
 * 				Parameters:    devtestlab.ArmTemplateParameterPropertiesArray{},
 * 			},
 * 			LabName:           pulumi.String("{labName}"),
 * 			Name:              pulumi.String("{environmentName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			UserName:          pulumi.String("@me"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Environment;
 * import com.pulumi.azurenative.devtestlab.EnvironmentArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environment = new Environment("environment", EnvironmentArgs.builder()
 *             .deploymentProperties(EnvironmentDeploymentPropertiesArgs.builder()
 *                 .armTemplateId("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}")
 *                 .parameters()
 *                 .build())
 *             .labName("{labName}")
 *             .name("{environmentName}")
 *             .resourceGroupName("resourceGroupName")
 *             .userName("@me")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Environment {environmentName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments/{name}
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * The display name of the Azure Resource Manager template that produced the environment.
     */
    public val armTemplateDisplayName: Output<String>?
        get() = javaResource.armTemplateDisplayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creator of the environment.
     */
    public val createdByUser: Output<String>
        get() = javaResource.createdByUser().applyValue({ args0 -> args0 })

    /**
     * The deployment properties of the environment.
     */
    public val deploymentProperties: Output<EnvironmentDeploymentPropertiesResponse>?
        get() = javaResource.deploymentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The identifier of the resource group containing the environment's resources.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.azurenative.devtestlab.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit):
    Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
