@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.ApplicableScheduleResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ApplicableScheduleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceFabric].
 */
@PulumiTagMarker
public class ServiceFabricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceFabricArgs = ServiceFabricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceFabricArgsBuilder.() -> Unit) {
        val builder = ServiceFabricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceFabric {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.ServiceFabric(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceFabric(builtJavaResource)
    }
}

/**
 * A Service Fabric.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * ## Example Usage
 * ### ServiceFabrics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceFabric = new AzureNative.DevTestLab.ServiceFabric("serviceFabric", new()
 *     {
 *         EnvironmentId = "{environmentId}",
 *         ExternalServiceFabricId = "{serviceFabricId}",
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{serviceFabricName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         UserName = "{userName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewServiceFabric(ctx, "serviceFabric", &devtestlab.ServiceFabricArgs{
 * 			EnvironmentId:           pulumi.String("{environmentId}"),
 * 			ExternalServiceFabricId: pulumi.String("{serviceFabricId}"),
 * 			LabName:                 pulumi.String("{labName}"),
 * 			Location:                pulumi.String("{location}"),
 * 			Name:                    pulumi.String("{serviceFabricName}"),
 * 			ResourceGroupName:       pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			UserName: pulumi.String("{userName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ServiceFabric;
 * import com.pulumi.azurenative.devtestlab.ServiceFabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceFabric = new ServiceFabric("serviceFabric", ServiceFabricArgs.builder()
 *             .environmentId("{environmentId}")
 *             .externalServiceFabricId("{serviceFabricId}")
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{serviceFabricName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .userName("{userName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ServiceFabric {serviceFabricName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/servicefabrics/{name}
 * ```
 */
public class ServiceFabric internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.ServiceFabric,
) : KotlinCustomResource(javaResource, ServiceFabricMapper) {
    /**
     * The applicable schedule for the virtual machine.
     */
    public val applicableSchedule: Output<ApplicableScheduleResponse>
        get() = javaResource.applicableSchedule().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The resource id of the environment under which the service fabric resource is present
     */
    public val environmentId: Output<String>?
        get() = javaResource.environmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The backing service fabric resource's id
     */
    public val externalServiceFabricId: Output<String>?
        get() = javaResource.externalServiceFabricId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object ServiceFabricMapper : ResourceMapper<ServiceFabric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.ServiceFabric::class == javaResource::class

    override fun map(javaResource: Resource): ServiceFabric = ServiceFabric(
        javaResource as
            com.pulumi.azurenative.devtestlab.ServiceFabric,
    )
}

/**
 * @see [ServiceFabric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceFabric].
 */
public suspend fun serviceFabric(
    name: String,
    block: suspend ServiceFabricResourceBuilder.() -> Unit,
): ServiceFabric {
    val builder = ServiceFabricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceFabric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceFabric(name: String): ServiceFabric {
    val builder = ServiceFabricResourceBuilder()
    builder.name(name)
    return builder.build()
}
