@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
 */
public enum class LinuxOsState(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.LinuxOsState,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.LinuxOsState> {
    NonDeprovisioned(com.pulumi.azurenative.devtestlab.enums.LinuxOsState.NonDeprovisioned),
    DeprovisionRequested(com.pulumi.azurenative.devtestlab.enums.LinuxOsState.DeprovisionRequested),
    DeprovisionApplied(com.pulumi.azurenative.devtestlab.enums.LinuxOsState.DeprovisionApplied),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.LinuxOsState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.LinuxOsState):
            LinuxOsState = LinuxOsState.values().first { it.javaValue == javaType }
    }
}
