@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetNotificationChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=webHookUrl)'
 * @property labName The name of the lab.
 * @property name The name of the notification channel.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNotificationChannelPlainArgs(
    public val expand: String? = null,
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetNotificationChannelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetNotificationChannelPlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.GetNotificationChannelPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .labName(labName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotificationChannelPlainArgs].
 */
@PulumiTagMarker
public class GetNotificationChannelPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=webHookUrl)'
     */
    @JvmName("mtieidsxeeterarj")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("ptcdyssrmkohhppv")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the notification channel.
     */
    @JvmName("nudvuxvcdttwlvsj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yprcbkqxkilpbmul")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNotificationChannelPlainArgs = GetNotificationChannelPlainArgs(
        expand = expand,
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
