@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.HourDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of an hourly schedule.
 * @property minute Minutes of the hour the schedule will run.
 */
public data class HourDetailsArgs(
    public val minute: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.HourDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.HourDetailsArgs =
        com.pulumi.azurenative.devtestlab.inputs.HourDetailsArgs.builder()
            .minute(minute?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HourDetailsArgs].
 */
@PulumiTagMarker
public class HourDetailsArgsBuilder internal constructor() {
    private var minute: Output<Int>? = null

    /**
     * @param value Minutes of the hour the schedule will run.
     */
    @JvmName("qardyouqgsmwncpu")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value Minutes of the hour the schedule will run.
     */
    @JvmName("iwpxchoirtqdlvvr")
    public suspend fun minute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    internal fun build(): HourDetailsArgs = HourDetailsArgs(
        minute = minute,
    )
}
