@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.IdentityPropertiesArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.ManagedIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a managed identity
 * @property clientSecretUrl The client secret URL of the identity.
 * @property principalId The principal id of resource identity.
 * @property tenantId The tenant identifier of resource.
 * @property type Managed identity.
 */
public data class IdentityPropertiesArgs(
    public val clientSecretUrl: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<Either<String, ManagedIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.IdentityPropertiesArgs.builder()
            .clientSecretUrl(clientSecretUrl?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var clientSecretUrl: Output<String>? = null

    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<Either<String, ManagedIdentityType>>? = null

    /**
     * @param value The client secret URL of the identity.
     */
    @JvmName("wxjjaubllhodiirt")
    public suspend fun clientSecretUrl(`value`: Output<String>) {
        this.clientSecretUrl = value
    }

    /**
     * @param value The principal id of resource identity.
     */
    @JvmName("udsjewvomrlunvco")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The tenant identifier of resource.
     */
    @JvmName("raffnonnvyxubkex")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Managed identity.
     */
    @JvmName("dvesptjmrtvhnojg")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The client secret URL of the identity.
     */
    @JvmName("ehugdylilnyuumvh")
    public suspend fun clientSecretUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretUrl = mapped
    }

    /**
     * @param value The principal id of resource identity.
     */
    @JvmName("cagudqscecbdcimr")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The tenant identifier of resource.
     */
    @JvmName("waxtcyesfhirocsi")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Managed identity.
     */
    @JvmName("umleyocbggqmyinn")
    public suspend fun type(`value`: Either<String, ManagedIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity.
     */
    @JvmName("tnrnrpktbjnilcyj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity.
     */
    @JvmName("tjhkmfpnbtnrfcpm")
    public fun type(`value`: ManagedIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        clientSecretUrl = clientSecretUrl,
        principalId = principalId,
        tenantId = tenantId,
        type = type,
    )
}
