@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.LabSupportPropertiesArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a lab's support banner
 * @property enabled Is the lab support banner active/enabled at this time?
 * @property markdown The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
 */
public data class LabSupportPropertiesArgs(
    public val enabled: Output<Either<String, EnableStatus>>? = null,
    public val markdown: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.LabSupportPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.LabSupportPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.LabSupportPropertiesArgs.builder()
            .enabled(
                enabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .markdown(markdown?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabSupportPropertiesArgs].
 */
@PulumiTagMarker
public class LabSupportPropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Either<String, EnableStatus>>? = null

    private var markdown: Output<String>? = null

    /**
     * @param value Is the lab support banner active/enabled at this time?
     */
    @JvmName("ynaobanlbgpkcpkq")
    public suspend fun enabled(`value`: Output<Either<String, EnableStatus>>) {
        this.enabled = value
    }

    /**
     * @param value The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
     */
    @JvmName("rqecrvcjywpgeelp")
    public suspend fun markdown(`value`: Output<String>) {
        this.markdown = value
    }

    /**
     * @param value Is the lab support banner active/enabled at this time?
     */
    @JvmName("tqiindpbojonvvlp")
    public suspend fun enabled(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Is the lab support banner active/enabled at this time?
     */
    @JvmName("estlgwqkjdjlnlmk")
    public fun enabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Is the lab support banner active/enabled at this time?
     */
    @JvmName("tnfxcwplxdgwaojf")
    public fun enabled(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
     */
    @JvmName("ibhecficotslpmdr")
    public suspend fun markdown(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markdown = mapped
    }

    internal fun build(): LabSupportPropertiesArgs = LabSupportPropertiesArgs(
        enabled = enabled,
        markdown = markdown,
    )
}
