@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.PortArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.TransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a network port.
 * @property backendPort Backend port of the target virtual machine.
 * @property transportProtocol Protocol type of the port.
 */
public data class PortArgs(
    public val backendPort: Output<Int>? = null,
    public val transportProtocol: Output<Either<String, TransportProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.PortArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.PortArgs =
        com.pulumi.azurenative.devtestlab.inputs.PortArgs.builder()
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .transportProtocol(
                transportProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PortArgs].
 */
@PulumiTagMarker
public class PortArgsBuilder internal constructor() {
    private var backendPort: Output<Int>? = null

    private var transportProtocol: Output<Either<String, TransportProtocol>>? = null

    /**
     * @param value Backend port of the target virtual machine.
     */
    @JvmName("eypunquwssdvlmwo")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Protocol type of the port.
     */
    @JvmName("laikhgrlolcfofoa")
    public suspend fun transportProtocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.transportProtocol = value
    }

    /**
     * @param value Backend port of the target virtual machine.
     */
    @JvmName("skfceuhjgcyvpbmq")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Protocol type of the port.
     */
    @JvmName("poaooyeolxgvlhep")
    public suspend fun transportProtocol(`value`: Either<String, TransportProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value Protocol type of the port.
     */
    @JvmName("xaplmxdelmtvoicj")
    public fun transportProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value Protocol type of the port.
     */
    @JvmName("odmvtnseidesxagp")
    public fun transportProtocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    internal fun build(): PortArgs = PortArgs(
        backendPort = backendPort,
        transportProtocol = transportProtocol,
    )
}
