@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.SubnetOverrideArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.UsagePermissionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Property overrides on a subnet of a virtual network.
 * @property labSubnetName The name given to the subnet within the lab.
 * @property resourceId The resource ID of the subnet.
 * @property sharedPublicIpAddressConfiguration Properties that virtual machines on this subnet will share.
 * @property useInVmCreationPermission Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
 * @property usePublicIpAddressPermission Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
 * @property virtualNetworkPoolName The virtual network pool associated with this subnet.
 */
public data class SubnetOverrideArgs(
    public val labSubnetName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val sharedPublicIpAddressConfiguration:
    Output<SubnetSharedPublicIpAddressConfigurationArgs>? = null,
    public val useInVmCreationPermission: Output<Either<String, UsagePermissionType>>? = null,
    public val usePublicIpAddressPermission: Output<Either<String, UsagePermissionType>>? = null,
    public val virtualNetworkPoolName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.SubnetOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.SubnetOverrideArgs =
        com.pulumi.azurenative.devtestlab.inputs.SubnetOverrideArgs.builder()
            .labSubnetName(labSubnetName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .sharedPublicIpAddressConfiguration(
                sharedPublicIpAddressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .useInVmCreationPermission(
                useInVmCreationPermission?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .usePublicIpAddressPermission(
                usePublicIpAddressPermission?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .virtualNetworkPoolName(virtualNetworkPoolName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetOverrideArgs].
 */
@PulumiTagMarker
public class SubnetOverrideArgsBuilder internal constructor() {
    private var labSubnetName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var sharedPublicIpAddressConfiguration:
        Output<SubnetSharedPublicIpAddressConfigurationArgs>? = null

    private var useInVmCreationPermission: Output<Either<String, UsagePermissionType>>? = null

    private var usePublicIpAddressPermission: Output<Either<String, UsagePermissionType>>? = null

    private var virtualNetworkPoolName: Output<String>? = null

    /**
     * @param value The name given to the subnet within the lab.
     */
    @JvmName("dqxowpygaskbsxyf")
    public suspend fun labSubnetName(`value`: Output<String>) {
        this.labSubnetName = value
    }

    /**
     * @param value The resource ID of the subnet.
     */
    @JvmName("qnoikdutodefvapn")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Properties that virtual machines on this subnet will share.
     */
    @JvmName("nlcxfspxqkxfmvxn")
    public suspend
    fun sharedPublicIpAddressConfiguration(`value`: Output<SubnetSharedPublicIpAddressConfigurationArgs>) {
        this.sharedPublicIpAddressConfiguration = value
    }

    /**
     * @param value Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
     */
    @JvmName("xnamqpttrothoycx")
    public suspend
    fun useInVmCreationPermission(`value`: Output<Either<String, UsagePermissionType>>) {
        this.useInVmCreationPermission = value
    }

    /**
     * @param value Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
     */
    @JvmName("ptqjmaaefpnntlfe")
    public suspend
    fun usePublicIpAddressPermission(`value`: Output<Either<String, UsagePermissionType>>) {
        this.usePublicIpAddressPermission = value
    }

    /**
     * @param value The virtual network pool associated with this subnet.
     */
    @JvmName("dkjgrgrptgsmiiii")
    public suspend fun virtualNetworkPoolName(`value`: Output<String>) {
        this.virtualNetworkPoolName = value
    }

    /**
     * @param value The name given to the subnet within the lab.
     */
    @JvmName("efnepryhmdfctufm")
    public suspend fun labSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labSubnetName = mapped
    }

    /**
     * @param value The resource ID of the subnet.
     */
    @JvmName("xfnlvkxnhpuqfnqv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Properties that virtual machines on this subnet will share.
     */
    @JvmName("vccllupqqsiqejdt")
    public suspend
    fun sharedPublicIpAddressConfiguration(`value`: SubnetSharedPublicIpAddressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPublicIpAddressConfiguration = mapped
    }

    /**
     * @param argument Properties that virtual machines on this subnet will share.
     */
    @JvmName("nxfvoxaeylrperel")
    public suspend
    fun sharedPublicIpAddressConfiguration(argument: suspend SubnetSharedPublicIpAddressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetSharedPublicIpAddressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedPublicIpAddressConfiguration = mapped
    }

    /**
     * @param value Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
     */
    @JvmName("rwjcxxwednswcrlg")
    public suspend fun useInVmCreationPermission(`value`: Either<String, UsagePermissionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInVmCreationPermission = mapped
    }

    /**
     * @param value Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
     */
    @JvmName("jlqxmpxlkeshbkik")
    public fun useInVmCreationPermission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useInVmCreationPermission = mapped
    }

    /**
     * @param value Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
     */
    @JvmName("qmojqhidkagjcsdq")
    public fun useInVmCreationPermission(`value`: UsagePermissionType) {
        val toBeMapped = Either.ofRight<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useInVmCreationPermission = mapped
    }

    /**
     * @param value Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
     */
    @JvmName("mhqrqhmnhimtgpyy")
    public suspend fun usePublicIpAddressPermission(`value`: Either<String, UsagePermissionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePublicIpAddressPermission = mapped
    }

    /**
     * @param value Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
     */
    @JvmName("pdlankawqfhuhdmj")
    public fun usePublicIpAddressPermission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usePublicIpAddressPermission = mapped
    }

    /**
     * @param value Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
     */
    @JvmName("hcfubxdnadddwdrs")
    public fun usePublicIpAddressPermission(`value`: UsagePermissionType) {
        val toBeMapped = Either.ofRight<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usePublicIpAddressPermission = mapped
    }

    /**
     * @param value The virtual network pool associated with this subnet.
     */
    @JvmName("jtxofjwpmrtitpct")
    public suspend fun virtualNetworkPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkPoolName = mapped
    }

    internal fun build(): SubnetOverrideArgs = SubnetOverrideArgs(
        labSubnetName = labSubnetName,
        resourceId = resourceId,
        sharedPublicIpAddressConfiguration = sharedPublicIpAddressConfiguration,
        useInVmCreationPermission = useInVmCreationPermission,
        usePublicIpAddressPermission = usePublicIpAddressPermission,
        virtualNetworkPoolName = virtualNetworkPoolName,
    )
}
