@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
 * @property id The identifier of the resource.
 * @property labVmsShutdown The auto-shutdown schedule, if one has been set at the lab or lab resource level.
 * @property labVmsStartup The auto-startup schedule, if one has been set at the lab or lab resource level.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 */
public data class ApplicableScheduleResponse(
    public val id: String,
    public val labVmsShutdown: ScheduleResponse? = null,
    public val labVmsStartup: ScheduleResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ApplicableScheduleResponse):
            ApplicableScheduleResponse = ApplicableScheduleResponse(
            id = javaType.id(),
            labVmsShutdown = javaType.labVmsShutdown().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            labVmsStartup = javaType.labVmsStartup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
