@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of an artifact.
 * @property artifactId The artifact's identifier.
 * @property artifactTitle The artifact's title.
 * @property deploymentStatusMessage The status message from the deployment.
 * @property installTime The time that the artifact starts to install on the virtual machine.
 * @property parameters The parameters of the artifact.
 * @property status The status of the artifact.
 * @property vmExtensionStatusMessage The status message from the virtual machine extension.
 */
public data class ArtifactInstallPropertiesResponse(
    public val artifactId: String? = null,
    public val artifactTitle: String? = null,
    public val deploymentStatusMessage: String? = null,
    public val installTime: String? = null,
    public val parameters: List<ArtifactParameterPropertiesResponse>? = null,
    public val status: String? = null,
    public val vmExtensionStatusMessage: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ArtifactInstallPropertiesResponse):
            ArtifactInstallPropertiesResponse = ArtifactInstallPropertiesResponse(
            artifactId = javaType.artifactId().map({ args0 -> args0 }).orElse(null),
            artifactTitle = javaType.artifactTitle().map({ args0 -> args0 }).orElse(null),
            deploymentStatusMessage = javaType.deploymentStatusMessage().map({ args0 -> args0 }).orElse(null),
            installTime = javaType.installTime().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactParameterPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vmExtensionStatusMessage = javaType.vmExtensionStatusMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
