@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties for creating a custom image from a VHD.
 * @property imageName The image name.
 * @property osType The OS type of the custom image (i.e. Windows, Linux)
 * @property sysPrep Indicates whether sysprep has been run on the VHD.
 */
public data class CustomImagePropertiesCustomResponse(
    public val imageName: String? = null,
    public val osType: String,
    public val sysPrep: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.CustomImagePropertiesCustomResponse):
            CustomImagePropertiesCustomResponse = CustomImagePropertiesCustomResponse(
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType(),
            sysPrep = javaType.sysPrep().map({ args0 -> args0 }).orElse(null),
        )
    }
}
