@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An event to be notified for.
 * @property eventName The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
 */
public data class EventResponse(
    public val eventName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.EventResponse):
            EventResponse = EventResponse(
            eventName = javaType.eventName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
