@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The reference information for an Azure Marketplace image.
 * @property offer The offer of the gallery image.
 * @property osType The OS type of the gallery image.
 * @property publisher The publisher of the gallery image.
 * @property sku The SKU of the gallery image.
 * @property version The version of the gallery image.
 */
public data class GalleryImageReferenceResponse(
    public val offer: String? = null,
    public val osType: String? = null,
    public val publisher: String? = null,
    public val sku: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GalleryImageReferenceResponse):
            GalleryImageReferenceResponse = GalleryImageReferenceResponse(
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
