@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A notification.
 * @property createdDate The creation date of the notification channel.
 * @property description Description of notification.
 * @property emailRecipient The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
 * @property events The list of event for which this notification is enabled.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property notificationLocale The locale to use when sending a notification (fallback for unsupported languages is EN).
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property webHookUrl The webhook URL to send notifications to.
 */
public data class GetNotificationChannelResult(
    public val createdDate: String,
    public val description: String? = null,
    public val emailRecipient: String? = null,
    public val events: List<EventResponse>? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val notificationLocale: String? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val webHookUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetNotificationChannelResult):
            GetNotificationChannelResult = GetNotificationChannelResult(
            createdDate = javaType.createdDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            emailRecipient = javaType.emailRecipient().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.EventResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notificationLocale = javaType.notificationLocale().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            webHookUrl = javaType.webHookUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
