@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties for creating a virtual machine.
 * @property allowClaim Indicates whether another user can take ownership of the virtual machine
 * @property artifacts The artifacts to be installed on the virtual machine.
 * @property bulkCreationParameters The number of virtual machine instances to create.
 * @property createdDate The creation date of the virtual machine.
 * @property customImageId The custom image identifier of the virtual machine.
 * @property dataDiskParameters New or existing data disks to attach to the virtual machine after creation
 * @property disallowPublicIpAddress Indicates whether the virtual machine is to be created without a public IP address.
 * @property environmentId The resource ID of the environment that contains this virtual machine, if any.
 * @property expirationDate The expiration date for VM.
 * @property galleryImageReference The Microsoft Azure Marketplace image reference of the virtual machine.
 * @property isAuthenticationWithSshKey Indicates whether this virtual machine uses an SSH key for authentication.
 * @property labSubnetName The lab subnet name of the virtual machine.
 * @property labVirtualNetworkId The lab virtual network identifier of the virtual machine.
 * @property location The location of the new virtual machine or environment
 * @property name The name of the virtual machine or environment
 * @property networkInterface The network interface properties.
 * @property notes The notes of the virtual machine.
 * @property ownerObjectId The object identifier of the owner of the virtual machine.
 * @property ownerUserPrincipalName The user principal name of the virtual machine owner.
 * @property password The password of the virtual machine administrator.
 * @property planId The id of the plan associated with the virtual machine image
 * @property scheduleParameters Virtual Machine schedules to be created
 * @property size The size of the virtual machine.
 * @property sshKey The SSH key of the virtual machine administrator.
 * @property storageType Storage type to use for virtual machine (i.e. Standard, Premium).
 * @property tags The tags of the resource.
 * @property userName The user name of the virtual machine.
 */
public data class LabVirtualMachineCreationParameterResponse(
    public val allowClaim: Boolean? = null,
    public val artifacts: List<ArtifactInstallPropertiesResponse>? = null,
    public val bulkCreationParameters: BulkCreationParametersResponse? = null,
    public val createdDate: String? = null,
    public val customImageId: String? = null,
    public val dataDiskParameters: List<DataDiskPropertiesResponse>? = null,
    public val disallowPublicIpAddress: Boolean? = null,
    public val environmentId: String? = null,
    public val expirationDate: String? = null,
    public val galleryImageReference: GalleryImageReferenceResponse? = null,
    public val isAuthenticationWithSshKey: Boolean? = null,
    public val labSubnetName: String? = null,
    public val labVirtualNetworkId: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val networkInterface: NetworkInterfacePropertiesResponse? = null,
    public val notes: String? = null,
    public val ownerObjectId: String? = null,
    public val ownerUserPrincipalName: String? = null,
    public val password: String? = null,
    public val planId: String? = null,
    public val scheduleParameters: List<ScheduleCreationParameterResponse>? = null,
    public val size: String? = null,
    public val sshKey: String? = null,
    public val storageType: String? = null,
    public val tags: Map<String, String>? = null,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.LabVirtualMachineCreationParameterResponse):
            LabVirtualMachineCreationParameterResponse = LabVirtualMachineCreationParameterResponse(
            allowClaim = javaType.allowClaim().map({ args0 -> args0 }).orElse(null),
            artifacts = javaType.artifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactInstallPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            bulkCreationParameters = javaType.bulkCreationParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.BulkCreationParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            customImageId = javaType.customImageId().map({ args0 -> args0 }).orElse(null),
            dataDiskParameters = javaType.dataDiskParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            disallowPublicIpAddress = javaType.disallowPublicIpAddress().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            galleryImageReference = javaType.galleryImageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.GalleryImageReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isAuthenticationWithSshKey = javaType.isAuthenticationWithSshKey().map({ args0 ->
                args0
            }).orElse(null),
            labSubnetName = javaType.labSubnetName().map({ args0 -> args0 }).orElse(null),
            labVirtualNetworkId = javaType.labVirtualNetworkId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkInterface = javaType.networkInterface().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.NetworkInterfacePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            ownerObjectId = javaType.ownerObjectId().map({ args0 -> args0 }).orElse(null),
            ownerUserPrincipalName = javaType.ownerUserPrincipalName().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            planId = javaType.planId().map({ args0 -> args0 }).orElse(null),
            scheduleParameters = javaType.scheduleParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ScheduleCreationParameterResponse.Companion.toKotlin(args0)
                })
            }),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            sshKey = javaType.sshKey().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
