@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a network interface.
 * @property dnsName The DNS name.
 * @property privateIpAddress The private IP address.
 * @property publicIpAddress The public IP address.
 * @property publicIpAddressId The resource ID of the public IP address.
 * @property rdpAuthority The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
 * @property sharedPublicIpAddressConfiguration The configuration for sharing a public IP address across multiple virtual machines.
 * @property sshAuthority The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
 * @property subnetId The resource ID of the sub net.
 * @property virtualNetworkId The resource ID of the virtual network.
 */
public data class NetworkInterfacePropertiesResponse(
    public val dnsName: String? = null,
    public val privateIpAddress: String? = null,
    public val publicIpAddress: String? = null,
    public val publicIpAddressId: String? = null,
    public val rdpAuthority: String? = null,
    public val sharedPublicIpAddressConfiguration: SharedPublicIpAddressConfigurationResponse? = null,
    public val sshAuthority: String? = null,
    public val subnetId: String? = null,
    public val virtualNetworkId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.NetworkInterfacePropertiesResponse):
            NetworkInterfacePropertiesResponse = NetworkInterfacePropertiesResponse(
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            publicIpAddress = javaType.publicIpAddress().map({ args0 -> args0 }).orElse(null),
            publicIpAddressId = javaType.publicIpAddressId().map({ args0 -> args0 }).orElse(null),
            rdpAuthority = javaType.rdpAuthority().map({ args0 -> args0 }).orElse(null),
            sharedPublicIpAddressConfiguration = javaType.sharedPublicIpAddressConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.SharedPublicIpAddressConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sshAuthority = javaType.sshAuthority().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            virtualNetworkId = javaType.virtualNetworkId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
