@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Notification settings for a schedule.
 * @property emailRecipient The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
 * @property notificationLocale The locale to use when sending a notification (fallback for unsupported languages is EN).
 * @property status If notifications are enabled for this schedule (i.e. Enabled, Disabled).
 * @property timeInMinutes Time in minutes before event at which notification will be sent.
 * @property webhookUrl The webhook URL to which the notification will be sent.
 */
public data class NotificationSettingsResponse(
    public val emailRecipient: String? = null,
    public val notificationLocale: String? = null,
    public val status: String? = null,
    public val timeInMinutes: Int? = null,
    public val webhookUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.NotificationSettingsResponse):
            NotificationSettingsResponse = NotificationSettingsResponse(
            emailRecipient = javaType.emailRecipient().map({ args0 -> args0 }).orElse(null),
            notificationLocale = javaType.notificationLocale().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            timeInMinutes = javaType.timeInMinutes().map({ args0 -> args0 }).orElse(null),
            webhookUrl = javaType.webhookUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
