@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a weekly schedule.
 * @property time The time of the day the schedule will occur.
 * @property weekdays The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
 */
public data class WeekDetailsResponse(
    public val time: String? = null,
    public val weekdays: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.WeekDetailsResponse):
            WeekDetailsResponse = WeekDetailsResponse(
            time = javaType.time().map({ args0 -> args0 }).orElse(null),
            weekdays = javaType.weekdays().map({ args0 -> args0 }),
        )
    }
}
