@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.kotlin.outputs.AzureDataExplorerConnectionPropertiesResponse
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.AzureDataExplorerConnectionPropertiesResponse.Companion.toKotlin as azureDataExplorerConnectionPropertiesResponseToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TimeSeriesDatabaseConnection].
 */
@PulumiTagMarker
public class TimeSeriesDatabaseConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TimeSeriesDatabaseConnectionArgs = TimeSeriesDatabaseConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TimeSeriesDatabaseConnectionArgsBuilder.() -> Unit) {
        val builder = TimeSeriesDatabaseConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TimeSeriesDatabaseConnection {
        val builtJavaResource =
            com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TimeSeriesDatabaseConnection(builtJavaResource)
    }
}

/**
 * Describes a time series database connection resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2021-06-30-preview.
 * ## Example Usage
 * ### Create or replace a time series database connection for a DigitalTwins instance with user assigned identity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var timeSeriesDatabaseConnection = new AzureNative.DigitalTwins.TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", new()
 *     {
 *         Properties = new AzureNative.DigitalTwins.Inputs.AzureDataExplorerConnectionPropertiesArgs
 *         {
 *             AdxDatabaseName = "myDatabase",
 *             AdxEndpointUri = "https://mycluster.kusto.windows.net",
 *             AdxResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster",
 *             AdxTableName = "myTable",
 *             ConnectionType = "AzureDataExplorer",
 *             EventHubEndpointUri = "sb://myeh.servicebus.windows.net/",
 *             EventHubEntityPath = "myeh",
 *             EventHubNamespaceResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh",
 *             Identity = new AzureNative.DigitalTwins.Inputs.ManagedIdentityReferenceArgs
 *             {
 *                 Type = AzureNative.DigitalTwins.IdentityType.UserAssigned,
 *                 UserAssignedIdentity = "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 *             },
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *         TimeSeriesDatabaseConnectionName = "myConnection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewTimeSeriesDatabaseConnection(ctx, "timeSeriesDatabaseConnection", &digitaltwins.TimeSeriesDatabaseConnectionArgs{
 * 			Properties: &digitaltwins.AzureDataExplorerConnectionPropertiesArgs{
 * 				AdxDatabaseName:             pulumi.String("myDatabase"),
 * 				AdxEndpointUri:              pulumi.String("https://mycluster.kusto.windows.net"),
 * 				AdxResourceId:               pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 * 				AdxTableName:                pulumi.String("myTable"),
 * 				ConnectionType:              pulumi.String("AzureDataExplorer"),
 * 				EventHubEndpointUri:         pulumi.String("sb://myeh.servicebus.windows.net/"),
 * 				EventHubEntityPath:          pulumi.String("myeh"),
 * 				EventHubNamespaceResourceId: pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 * 				Identity: &digitaltwins.ManagedIdentityReferenceArgs{
 * 					Type:                 pulumi.String(digitaltwins.IdentityTypeUserAssigned),
 * 					UserAssignedIdentity: pulumi.String("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
 * 				},
 * 			},
 * 			ResourceGroupName:                pulumi.String("resRg"),
 * 			ResourceName:                     pulumi.String("myDigitalTwinsService"),
 * 			TimeSeriesDatabaseConnectionName: pulumi.String("myConnection"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs;
 * import com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs;
 * import com.pulumi.azurenative.digitaltwins.inputs.ManagedIdentityReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var timeSeriesDatabaseConnection = new TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", TimeSeriesDatabaseConnectionArgs.builder()
 *             .properties(AzureDataExplorerConnectionPropertiesArgs.builder()
 *                 .adxDatabaseName("myDatabase")
 *                 .adxEndpointUri("https://mycluster.kusto.windows.net")
 *                 .adxResourceId("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster")
 *                 .adxTableName("myTable")
 *                 .connectionType("AzureDataExplorer")
 *                 .eventHubEndpointUri("sb://myeh.servicebus.windows.net/")
 *                 .eventHubEntityPath("myeh")
 *                 .eventHubNamespaceResourceId("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh")
 *                 .identity(ManagedIdentityReferenceArgs.builder()
 *                     .type("UserAssigned")
 *                     .userAssignedIdentity("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .timeSeriesDatabaseConnectionName("myConnection")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or replace a time series database connection for a DigitalTwins instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var timeSeriesDatabaseConnection = new AzureNative.DigitalTwins.TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", new()
 *     {
 *         Properties = new AzureNative.DigitalTwins.Inputs.AzureDataExplorerConnectionPropertiesArgs
 *         {
 *             AdxDatabaseName = "myDatabase",
 *             AdxEndpointUri = "https://mycluster.kusto.windows.net",
 *             AdxRelationshipLifecycleEventsTableName = "myRelationshipLifecycleEventsTable",
 *             AdxResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster",
 *             AdxTableName = "myPropertyUpdatesTable",
 *             AdxTwinLifecycleEventsTableName = "myTwinLifecycleEventsTable",
 *             ConnectionType = "AzureDataExplorer",
 *             EventHubEndpointUri = "sb://myeh.servicebus.windows.net/",
 *             EventHubEntityPath = "myeh",
 *             EventHubNamespaceResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh",
 *             RecordPropertyAndItemRemovals = AzureNative.DigitalTwins.RecordPropertyAndItemRemovals.@True,
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *         TimeSeriesDatabaseConnectionName = "myConnection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewTimeSeriesDatabaseConnection(ctx, "timeSeriesDatabaseConnection", &digitaltwins.TimeSeriesDatabaseConnectionArgs{
 * 			Properties: &digitaltwins.AzureDataExplorerConnectionPropertiesArgs{
 * 				AdxDatabaseName:                         pulumi.String("myDatabase"),
 * 				AdxEndpointUri:                          pulumi.String("https://mycluster.kusto.windows.net"),
 * 				AdxRelationshipLifecycleEventsTableName: pulumi.String("myRelationshipLifecycleEventsTable"),
 * 				AdxResourceId:                           pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 * 				AdxTableName:                            pulumi.String("myPropertyUpdatesTable"),
 * 				AdxTwinLifecycleEventsTableName:         pulumi.String("myTwinLifecycleEventsTable"),
 * 				ConnectionType:                          pulumi.String("AzureDataExplorer"),
 * 				EventHubEndpointUri:                     pulumi.String("sb://myeh.servicebus.windows.net/"),
 * 				EventHubEntityPath:                      pulumi.String("myeh"),
 * 				EventHubNamespaceResourceId:             pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 * 				RecordPropertyAndItemRemovals:           pulumi.String(digitaltwins.RecordPropertyAndItemRemovalsTrue),
 * 			},
 * 			ResourceGroupName:                pulumi.String("resRg"),
 * 			ResourceName:                     pulumi.String("myDigitalTwinsService"),
 * 			TimeSeriesDatabaseConnectionName: pulumi.String("myConnection"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs;
 * import com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var timeSeriesDatabaseConnection = new TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", TimeSeriesDatabaseConnectionArgs.builder()
 *             .properties(AzureDataExplorerConnectionPropertiesArgs.builder()
 *                 .adxDatabaseName("myDatabase")
 *                 .adxEndpointUri("https://mycluster.kusto.windows.net")
 *                 .adxRelationshipLifecycleEventsTableName("myRelationshipLifecycleEventsTable")
 *                 .adxResourceId("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster")
 *                 .adxTableName("myPropertyUpdatesTable")
 *                 .adxTwinLifecycleEventsTableName("myTwinLifecycleEventsTable")
 *                 .connectionType("AzureDataExplorer")
 *                 .eventHubEndpointUri("sb://myeh.servicebus.windows.net/")
 *                 .eventHubEntityPath("myeh")
 *                 .eventHubNamespaceResourceId("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh")
 *                 .recordPropertyAndItemRemovals("true")
 *                 .build())
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .timeSeriesDatabaseConnectionName("myConnection")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:TimeSeriesDatabaseConnection myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}/timeSeriesDatabaseConnections/{timeSeriesDatabaseConnectionName}
 * ```
 */
public class TimeSeriesDatabaseConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection,
) : KotlinCustomResource(javaResource, TimeSeriesDatabaseConnectionMapper) {
    /**
     * Extension resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a specific time series database connection.
     */
    public val properties: Output<AzureDataExplorerConnectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                azureDataExplorerConnectionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TimeSeriesDatabaseConnectionMapper : ResourceMapper<TimeSeriesDatabaseConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection::class == javaResource::class

    override fun map(javaResource: Resource): TimeSeriesDatabaseConnection =
        TimeSeriesDatabaseConnection(
            javaResource as
                com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection,
        )
}

/**
 * @see [TimeSeriesDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TimeSeriesDatabaseConnection].
 */
public suspend fun timeSeriesDatabaseConnection(
    name: String,
    block: suspend TimeSeriesDatabaseConnectionResourceBuilder.() -> Unit,
):
    TimeSeriesDatabaseConnection {
    val builder = TimeSeriesDatabaseConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TimeSeriesDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun timeSeriesDatabaseConnection(name: String): TimeSeriesDatabaseConnection {
    val builder = TimeSeriesDatabaseConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
