@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.DigitalTwinsIdentityArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.DigitalTwinsIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The managed identity for the DigitalTwinsInstance.
 * @property type The type of Managed Identity used by the DigitalTwinsInstance.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 * .
 */
public data class DigitalTwinsIdentityArgs(
    public val type: Output<Either<String, DigitalTwinsIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.DigitalTwinsIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.DigitalTwinsIdentityArgs =
        com.pulumi.azurenative.digitaltwins.inputs.DigitalTwinsIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DigitalTwinsIdentityArgs].
 */
@PulumiTagMarker
public class DigitalTwinsIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, DigitalTwinsIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of Managed Identity used by the DigitalTwinsInstance.
     */
    @JvmName("yocqbdvcpdggbtnq")
    public suspend fun type(`value`: Output<Either<String, DigitalTwinsIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * .
     */
    @JvmName("jihuujypvummqjqd")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("wiyclybertymolua")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * .
     */
    @JvmName("igwmkywouwtlarwj")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of Managed Identity used by the DigitalTwinsInstance.
     */
    @JvmName("iwaalrtmeintbuxq")
    public suspend fun type(`value`: Either<String, DigitalTwinsIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of Managed Identity used by the DigitalTwinsInstance.
     */
    @JvmName("edgrehvrcvhsgxkn")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DigitalTwinsIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of Managed Identity used by the DigitalTwinsInstance.
     */
    @JvmName("xladheonwpkjytmd")
    public fun type(`value`: DigitalTwinsIdentityType) {
        val toBeMapped = Either.ofRight<String, DigitalTwinsIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * .
     */
    @JvmName("urpvikirgiwviqjw")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * .
     */
    @JvmName("kinbbsuylekhewnt")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): DigitalTwinsIdentityArgs = DigitalTwinsIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
