@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.EventHubArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties related to EventHub.
 * @property authenticationType Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 * @property connectionStringPrimaryKey PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 * @property connectionStringSecondaryKey SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 * @property deadLetterSecret Dead letter storage secret for key-based authentication. Will be obfuscated during read.
 * @property deadLetterUri Dead letter storage URL for identity-based authentication.
 * @property endpointType The type of Digital Twins endpoint
 * Expected value is 'EventHub'.
 * @property endpointUri The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
 * @property entityPath The EventHub name in the EventHub namespace for identity-based authentication.
 * @property identity Managed identity properties for the endpoint.
 */
public data class EventHubArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val connectionStringPrimaryKey: Output<String>? = null,
    public val connectionStringSecondaryKey: Output<String>? = null,
    public val deadLetterSecret: Output<String>? = null,
    public val deadLetterUri: Output<String>? = null,
    public val endpointType: Output<String>,
    public val endpointUri: Output<String>? = null,
    public val entityPath: Output<String>? = null,
    public val identity: Output<ManagedIdentityReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.EventHubArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.EventHubArgs =
        com.pulumi.azurenative.digitaltwins.inputs.EventHubArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionStringPrimaryKey(connectionStringPrimaryKey?.applyValue({ args0 -> args0 }))
            .connectionStringSecondaryKey(connectionStringSecondaryKey?.applyValue({ args0 -> args0 }))
            .deadLetterSecret(deadLetterSecret?.applyValue({ args0 -> args0 }))
            .deadLetterUri(deadLetterUri?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .endpointUri(endpointUri?.applyValue({ args0 -> args0 }))
            .entityPath(entityPath?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventHubArgs].
 */
@PulumiTagMarker
public class EventHubArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var connectionStringPrimaryKey: Output<String>? = null

    private var connectionStringSecondaryKey: Output<String>? = null

    private var deadLetterSecret: Output<String>? = null

    private var deadLetterUri: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var endpointUri: Output<String>? = null

    private var entityPath: Output<String>? = null

    private var identity: Output<ManagedIdentityReferenceArgs>? = null

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("qxddomkycflqeuro")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("gbdcnonignvcufhv")
    public suspend fun connectionStringPrimaryKey(`value`: Output<String>) {
        this.connectionStringPrimaryKey = value
    }

    /**
     * @param value SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("yyffygqqefmyfnoj")
    public suspend fun connectionStringSecondaryKey(`value`: Output<String>) {
        this.connectionStringSecondaryKey = value
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("livwrknqhvtvqfue")
    public suspend fun deadLetterSecret(`value`: Output<String>) {
        this.deadLetterSecret = value
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("tpusscvwxgkdotfh")
    public suspend fun deadLetterUri(`value`: Output<String>) {
        this.deadLetterUri = value
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'EventHub'.
     */
    @JvmName("vgytakypvedhslpc")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
     */
    @JvmName("acgoyhmyxtcsvnqu")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value The EventHub name in the EventHub namespace for identity-based authentication.
     */
    @JvmName("wsucbxlotyyitgtv")
    public suspend fun entityPath(`value`: Output<String>) {
        this.entityPath = value
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("mymcsitkmcrjcguw")
    public suspend fun identity(`value`: Output<ManagedIdentityReferenceArgs>) {
        this.identity = value
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("vvimxpvvugtdvrjj")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("vhhtjmnifdsugqmi")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("aidangxsejnhritb")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("alrckuqngcdlnkea")
    public suspend fun connectionStringPrimaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringPrimaryKey = mapped
    }

    /**
     * @param value SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("nruskxjtredkqjqb")
    public suspend fun connectionStringSecondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringSecondaryKey = mapped
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("vtpoahfdtrkjkrtp")
    public suspend fun deadLetterSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterSecret = mapped
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("fnmguyhokaguwlyu")
    public suspend fun deadLetterUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterUri = mapped
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'EventHub'.
     */
    @JvmName("pdpfimqnuljhvxtc")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
     */
    @JvmName("pofnxstvagbkefbn")
    public suspend fun endpointUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value The EventHub name in the EventHub namespace for identity-based authentication.
     */
    @JvmName("wtfdxgbjgdrivuke")
    public suspend fun entityPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityPath = mapped
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("fjscmoplkeabtmxr")
    public suspend fun identity(`value`: ManagedIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties for the endpoint.
     */
    @JvmName("pxaqljycgcwaeeaa")
    public suspend fun identity(argument: suspend ManagedIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    internal fun build(): EventHubArgs = EventHubArgs(
        authenticationType = authenticationType,
        connectionStringPrimaryKey = connectionStringPrimaryKey,
        connectionStringSecondaryKey = connectionStringSecondaryKey,
        deadLetterSecret = deadLetterSecret,
        deadLetterUri = deadLetterUri,
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        endpointUri = endpointUri,
        entityPath = entityPath,
        identity = identity,
    )
}
