@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The information about the user assigned identity.
 * @property clientId The client id of the User Assigned Identity Resource.
 * @property principalId The object id of the User Assigned Identity Resource.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.UserAssignedIdentityResponse):
            UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
