@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.DataCenterResourceResponseProperties
import com.pulumi.azurenative.documentdb.kotlin.outputs.DataCenterResourceResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CassandraDataCenter].
 */
@PulumiTagMarker
public class CassandraDataCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CassandraDataCenterArgs = CassandraDataCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CassandraDataCenterArgsBuilder.() -> Unit) {
        val builder = CassandraDataCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CassandraDataCenter {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.CassandraDataCenter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CassandraDataCenter(builtJavaResource)
    }
}

/**
 * A managed Cassandra data center.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBManagedCassandraDataCenterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraDataCenter = new AzureNative.DocumentDB.CassandraDataCenter("cassandraDataCenter", new()
 *     {
 *         ClusterName = "cassandra-prod",
 *         DataCenterName = "dc1",
 *         Properties = new AzureNative.DocumentDB.Inputs.DataCenterResourcePropertiesArgs
 *         {
 *             Base64EncodedCassandraYamlFragment = "Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA=",
 *             DataCenterLocation = "West US 2",
 *             DelegatedSubnetId = "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet",
 *             NodeCount = 9,
 *         },
 *         ResourceGroupName = "cassandra-prod-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraDataCenter(ctx, "cassandraDataCenter", &documentdb.CassandraDataCenterArgs{
 * 			ClusterName:    pulumi.String("cassandra-prod"),
 * 			DataCenterName: pulumi.String("dc1"),
 * 			Properties: &documentdb.DataCenterResourcePropertiesArgs{
 * 				Base64EncodedCassandraYamlFragment: pulumi.String("Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA="),
 * 				DataCenterLocation:                 pulumi.String("West US 2"),
 * 				DelegatedSubnetId:                  pulumi.String("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet"),
 * 				NodeCount:                          pulumi.Int(9),
 * 			},
 * 			ResourceGroupName: pulumi.String("cassandra-prod-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraDataCenter;
 * import com.pulumi.azurenative.documentdb.CassandraDataCenterArgs;
 * import com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraDataCenter = new CassandraDataCenter("cassandraDataCenter", CassandraDataCenterArgs.builder()
 *             .clusterName("cassandra-prod")
 *             .dataCenterName("dc1")
 *             .properties(DataCenterResourcePropertiesArgs.builder()
 *                 .base64EncodedCassandraYamlFragment("Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA=")
 *                 .dataCenterLocation("West US 2")
 *                 .delegatedSubnetId("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet")
 *                 .nodeCount(9)
 *                 .build())
 *             .resourceGroupName("cassandra-prod-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraDataCenter dc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}
 * ```
 */
public class CassandraDataCenter internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.CassandraDataCenter,
) : KotlinCustomResource(javaResource, CassandraDataCenterMapper) {
    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a managed Cassandra data center.
     */
    public val properties: Output<DataCenterResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CassandraDataCenterMapper : ResourceMapper<CassandraDataCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.CassandraDataCenter::class == javaResource::class

    override fun map(javaResource: Resource): CassandraDataCenter = CassandraDataCenter(
        javaResource
            as com.pulumi.azurenative.documentdb.CassandraDataCenter,
    )
}

/**
 * @see [CassandraDataCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CassandraDataCenter].
 */
public suspend fun cassandraDataCenter(
    name: String,
    block: suspend CassandraDataCenterResourceBuilder.() -> Unit,
): CassandraDataCenter {
    val builder = CassandraDataCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CassandraDataCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cassandraDataCenter(name: String): CassandraDataCenter {
    val builder = CassandraDataCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
