@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CassandraViewResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CassandraViewResourceArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Cassandra view.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2023-09-15-preview, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBCassandraViewCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraResourceCassandraView = new AzureNative.DocumentDB.CassandraResourceCassandraView("cassandraResourceCassandraView", new()
 *     {
 *         AccountName = "ddb1",
 *         KeyspaceName = "keyspacename",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.CassandraViewResourceArgs
 *         {
 *             Id = "viewname",
 *             ViewDefinition = "SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *         ViewName = "viewname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraResourceCassandraView(ctx, "cassandraResourceCassandraView", &documentdb.CassandraResourceCassandraViewArgs{
 * 			AccountName:  pulumi.String("ddb1"),
 * 			KeyspaceName: pulumi.String("keyspacename"),
 * 			Options:      nil,
 * 			Resource: &documentdb.CassandraViewResourceArgs{
 * 				Id:             pulumi.String("viewname"),
 * 				ViewDefinition: pulumi.String("SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 			ViewName:          pulumi.String("viewname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraView;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraResourceCassandraView = new CassandraResourceCassandraView("cassandraResourceCassandraView", CassandraResourceCassandraViewArgs.builder()
 *             .accountName("ddb1")
 *             .keyspaceName("keyspacename")
 *             .options()
 *             .resource(CassandraViewResourceArgs.builder()
 *                 .id("viewname")
 *                 .viewDefinition("SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .viewName("viewname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraResourceCassandraView viewname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property identity Identity for the resource.
 * @property keyspaceName Cosmos DB keyspace name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a Cassandra view
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property viewName Cosmos DB view name.
 */
public data class CassandraResourceCassandraViewArgs(
    public val accountName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val keyspaceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<CassandraViewResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val viewName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs =
        com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyspaceName(keyspaceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .viewName(viewName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CassandraResourceCassandraViewArgs].
 */
@PulumiTagMarker
public class CassandraResourceCassandraViewArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var keyspaceName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<CassandraViewResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var viewName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("xsypldbcftsverlu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("xnrxnsaayknjpydu")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Cosmos DB keyspace name.
     */
    @JvmName("sirtasbdloodkikl")
    public suspend fun keyspaceName(`value`: Output<String>) {
        this.keyspaceName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("yritroywiugndnlh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("vijrjxomgnhdkhxc")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a Cassandra view
     */
    @JvmName("obwqxljgbcmipauj")
    public suspend fun resource(`value`: Output<CassandraViewResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pgvqrynhdvdgacif")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("elacrwkvpogdatgf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB view name.
     */
    @JvmName("gbipijiyqnbyesqn")
    public suspend fun viewName(`value`: Output<String>) {
        this.viewName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("qtqtckssdtjlyfxb")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("gqugqtgxgqpvonrn")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("iqfqwyoplsoubsoq")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Cosmos DB keyspace name.
     */
    @JvmName("khiwuitatniyjbco")
    public suspend fun keyspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyspaceName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("xhtylvlqibfwnepj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("ernfvlaplrpwgujl")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("jnhhibvxbsgbqkol")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a Cassandra view
     */
    @JvmName("gliaydfomemqcsgr")
    public suspend fun resource(`value`: CassandraViewResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a Cassandra view
     */
    @JvmName("xkflwsmovgthfkra")
    public suspend fun resource(argument: suspend CassandraViewResourceArgsBuilder.() -> Unit) {
        val toBeMapped = CassandraViewResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("obuvfyfcxcwwtjmu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("leofyotqpeyikgcl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("mikapjstcauilrlh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Cosmos DB view name.
     */
    @JvmName("rjxmovauijlgbucx")
    public suspend fun viewName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewName = mapped
    }

    internal fun build(): CassandraResourceCassandraViewArgs = CassandraResourceCassandraViewArgs(
        accountName = accountName,
        identity = identity,
        keyspaceName = keyspaceName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
        viewName = viewName,
    )
}
