@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinDatabaseGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinDatabaseGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinDatabaseGetPropertiesResponseOptions.Companion.toKotlin as gremlinDatabaseGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinDatabaseGetPropertiesResponseResource.Companion.toKotlin as gremlinDatabaseGetPropertiesResponseResourceToKotlin

/**
 * Builder for [GremlinResourceGremlinDatabase].
 */
@PulumiTagMarker
public class GremlinResourceGremlinDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GremlinResourceGremlinDatabaseArgs = GremlinResourceGremlinDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GremlinResourceGremlinDatabaseArgsBuilder.() -> Unit) {
        val builder = GremlinResourceGremlinDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GremlinResourceGremlinDatabase {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabase(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GremlinResourceGremlinDatabase(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Gremlin database.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBGremlinDatabaseCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gremlinResourceGremlinDatabase = new AzureNative.DocumentDB.GremlinResourceGremlinDatabase("gremlinResourceGremlinDatabase", new()
 *     {
 *         AccountName = "ddb1",
 *         DatabaseName = "databaseName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.GremlinDatabaseResourceArgs
 *         {
 *             Id = "databaseName",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewGremlinResourceGremlinDatabase(ctx, "gremlinResourceGremlinDatabase", &documentdb.GremlinResourceGremlinDatabaseArgs{
 * 			AccountName:  pulumi.String("ddb1"),
 * 			DatabaseName: pulumi.String("databaseName"),
 * 			Location:     pulumi.String("West US"),
 * 			Options:      nil,
 * 			Resource: &documentdb.GremlinDatabaseResourceArgs{
 * 				Id: pulumi.String("databaseName"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabase;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabaseArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gremlinResourceGremlinDatabase = new GremlinResourceGremlinDatabase("gremlinResourceGremlinDatabase", GremlinResourceGremlinDatabaseArgs.builder()
 *             .accountName("ddb1")
 *             .databaseName("databaseName")
 *             .location("West US")
 *             .options()
 *             .resource(GremlinDatabaseResourceArgs.builder()
 *                 .id("databaseName")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:GremlinResourceGremlinDatabase databaseName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}
 * ```
 */
public class GremlinResourceGremlinDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabase,
) : KotlinCustomResource(javaResource, GremlinResourceGremlinDatabaseMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<GremlinDatabaseGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gremlinDatabaseGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<GremlinDatabaseGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gremlinDatabaseGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GremlinResourceGremlinDatabaseMapper : ResourceMapper<GremlinResourceGremlinDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabase::class == javaResource::class

    override fun map(javaResource: Resource): GremlinResourceGremlinDatabase =
        GremlinResourceGremlinDatabase(
            javaResource as
                com.pulumi.azurenative.documentdb.GremlinResourceGremlinDatabase,
        )
}

/**
 * @see [GremlinResourceGremlinDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GremlinResourceGremlinDatabase].
 */
public suspend fun gremlinResourceGremlinDatabase(
    name: String,
    block: suspend GremlinResourceGremlinDatabaseResourceBuilder.() -> Unit,
):
    GremlinResourceGremlinDatabase {
    val builder = GremlinResourceGremlinDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GremlinResourceGremlinDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gremlinResourceGremlinDatabase(name: String): GremlinResourceGremlinDatabase {
    val builder = GremlinResourceGremlinDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
