@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GremlinGraphResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GremlinGraphResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Gremlin graph.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBGremlinGraphCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gremlinResourceGremlinGraph = new AzureNative.DocumentDB.GremlinResourceGremlinGraph("gremlinResourceGremlinGraph", new()
 *     {
 *         AccountName = "ddb1",
 *         DatabaseName = "databaseName",
 *         GraphName = "graphName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.GremlinGraphResourceArgs
 *         {
 *             ConflictResolutionPolicy = new AzureNative.DocumentDB.Inputs.ConflictResolutionPolicyArgs
 *             {
 *                 ConflictResolutionPath = "/path",
 *                 Mode = AzureNative.DocumentDB.ConflictResolutionMode.LastWriterWins,
 *             },
 *             DefaultTtl = 100,
 *             Id = "graphName",
 *             IndexingPolicy = new AzureNative.DocumentDB.Inputs.IndexingPolicyArgs
 *             {
 *                 Automatic = true,
 *                 ExcludedPaths = new() { },
 *                 IncludedPaths = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.IncludedPathArgs
 *                     {
 *                         Indexes = new[]
 *                         {
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = AzureNative.DocumentDB.DataType.String,
 *                                 Kind = AzureNative.DocumentDB.IndexKind.Range,
 *                                 Precision = -1,
 *                             },
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = AzureNative.DocumentDB.DataType.Number,
 *                                 Kind = AzureNative.DocumentDB.IndexKind.Range,
 *                                 Precision = -1,
 *                             },
 *                         },
 *                         Path = "/*",
 *                     },
 *                 },
 *                 IndexingMode = AzureNative.DocumentDB.IndexingMode.Consistent,
 *             },
 *             PartitionKey = new AzureNative.DocumentDB.Inputs.ContainerPartitionKeyArgs
 *             {
 *                 Kind = AzureNative.DocumentDB.PartitionKind.Hash,
 *                 Paths = new[]
 *                 {
 *                     "/AccountNumber",
 *                 },
 *             },
 *             UniqueKeyPolicy = new AzureNative.DocumentDB.Inputs.UniqueKeyPolicyArgs
 *             {
 *                 UniqueKeys = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.UniqueKeyArgs
 *                     {
 *                         Paths = new[]
 *                         {
 *                             "/testPath",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewGremlinResourceGremlinGraph(ctx, "gremlinResourceGremlinGraph", &documentdb.GremlinResourceGremlinGraphArgs{
 * 			AccountName:  pulumi.String("ddb1"),
 * 			DatabaseName: pulumi.String("databaseName"),
 * 			GraphName:    pulumi.String("graphName"),
 * 			Location:     pulumi.String("West US"),
 * 			Options:      nil,
 * 			Resource: &documentdb.GremlinGraphResourceArgs{
 * 				ConflictResolutionPolicy: &documentdb.ConflictResolutionPolicyArgs{
 * 					ConflictResolutionPath: pulumi.String("/path"),
 * 					Mode:                   pulumi.String(documentdb.ConflictResolutionModeLastWriterWins),
 * 				},
 * 				DefaultTtl: pulumi.Int(100),
 * 				Id:         pulumi.String("graphName"),
 * 				IndexingPolicy: &documentdb.IndexingPolicyArgs{
 * 					Automatic:     pulumi.Bool(true),
 * 					ExcludedPaths: documentdb.ExcludedPathArray{},
 * 					IncludedPaths: documentdb.IncludedPathArray{
 * 						&documentdb.IncludedPathArgs{
 * 							Indexes: documentdb.IndexesArray{
 * 								&documentdb.IndexesArgs{
 * 									DataType:  pulumi.String(documentdb.DataTypeString),
 * 									Kind:      pulumi.String(documentdb.IndexKindRange),
 * 									Precision: -1,
 * 								},
 * 								&documentdb.IndexesArgs{
 * 									DataType:  pulumi.String(documentdb.DataTypeNumber),
 * 									Kind:      pulumi.String(documentdb.IndexKindRange),
 * 									Precision: -1,
 * 								},
 * 							},
 * 							Path: pulumi.String("/*"),
 * 						},
 * 					},
 * 					IndexingMode: pulumi.String(documentdb.IndexingModeConsistent),
 * 				},
 * 				PartitionKey: &documentdb.ContainerPartitionKeyArgs{
 * 					Kind: pulumi.String(documentdb.PartitionKindHash),
 * 					Paths: pulumi.StringArray{
 * 						pulumi.String("/AccountNumber"),
 * 					},
 * 				},
 * 				UniqueKeyPolicy: &documentdb.UniqueKeyPolicyArgs{
 * 					UniqueKeys: documentdb.UniqueKeyArray{
 * 						&documentdb.UniqueKeyArgs{
 * 							Paths: pulumi.StringArray{
 * 								pulumi.String("/testPath"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.GremlinGraphResourceArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ConflictResolutionPolicyArgs;
 * import com.pulumi.azurenative.documentdb.inputs.IndexingPolicyArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ContainerPartitionKeyArgs;
 * import com.pulumi.azurenative.documentdb.inputs.UniqueKeyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gremlinResourceGremlinGraph = new GremlinResourceGremlinGraph("gremlinResourceGremlinGraph", GremlinResourceGremlinGraphArgs.builder()
 *             .accountName("ddb1")
 *             .databaseName("databaseName")
 *             .graphName("graphName")
 *             .location("West US")
 *             .options()
 *             .resource(GremlinGraphResourceArgs.builder()
 *                 .conflictResolutionPolicy(ConflictResolutionPolicyArgs.builder()
 *                     .conflictResolutionPath("/path")
 *                     .mode("LastWriterWins")
 *                     .build())
 *                 .defaultTtl(100)
 *                 .id("graphName")
 *                 .indexingPolicy(IndexingPolicyArgs.builder()
 *                     .automatic(true)
 *                     .excludedPaths()
 *                     .includedPaths(IncludedPathArgs.builder()
 *                         .indexes(
 *                             IndexesArgs.builder()
 *                                 .dataType("String")
 *                                 .kind("Range")
 *                                 .precision("TODO: GenUnaryOpExpression")
 *                                 .build(),
 *                             IndexesArgs.builder()
 *                                 .dataType("Number")
 *                                 .kind("Range")
 *                                 .precision("TODO: GenUnaryOpExpression")
 *                                 .build())
 *                         .path("/*")
 *                         .build())
 *                     .indexingMode("consistent")
 *                     .build())
 *                 .partitionKey(ContainerPartitionKeyArgs.builder()
 *                     .kind("Hash")
 *                     .paths("/AccountNumber")
 *                     .build())
 *                 .uniqueKeyPolicy(UniqueKeyPolicyArgs.builder()
 *                     .uniqueKeys(UniqueKeyArgs.builder()
 *                         .paths("/testPath")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:GremlinResourceGremlinGraph graphName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property databaseName Cosmos DB database name.
 * @property graphName Cosmos DB graph name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a Gremlin graph
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * */*/*/
 */
public data class GremlinResourceGremlinGraphArgs(
    public val accountName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val graphName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<GremlinGraphResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs =
        com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .graphName(graphName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GremlinResourceGremlinGraphArgs].
 */
@PulumiTagMarker
public class GremlinResourceGremlinGraphArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var graphName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<GremlinGraphResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("bikvdsolkkwaumpc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("wicslxjfcmyvwput")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Cosmos DB graph name.
     */
    @JvmName("blqjuwcpxklceoqy")
    public suspend fun graphName(`value`: Output<String>) {
        this.graphName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("syfchilqfgrkptgh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("axeroepglienxyli")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a Gremlin graph
     */
    @JvmName("aruqauwxyrduyhiu")
    public suspend fun resource(`value`: Output<GremlinGraphResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppoiddcqatyatkgj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("mbrprhcvwsunfxee")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("inkxxudmmunqdpuw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("efnpilgoewmkiqjo")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Cosmos DB graph name.
     */
    @JvmName("mwypvgqumeyibcrk")
    public suspend fun graphName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("rbibptsdgtukufuj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("emcwmktwbhifuqre")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("aglkxrskllidcvlb")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a Gremlin graph
     */
    @JvmName("jnddxgqneaqcogwh")
    public suspend fun resource(`value`: GremlinGraphResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a Gremlin graph
     */
    @JvmName("udqpsslyvoospmis")
    public suspend fun resource(argument: suspend GremlinGraphResourceArgsBuilder.() -> Unit) {
        val toBeMapped = GremlinGraphResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("osioavfaslifemvj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("efknbaatayudtemp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("aivbqqhqillxmrck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GremlinResourceGremlinGraphArgs = GremlinResourceGremlinGraphArgs(
        accountName = accountName,
        databaseName = databaseName,
        graphName = graphName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
